/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mail;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.mail.MailAuthenticator;
import org.nuxeo.mail.MailLogOutputStream;
import org.nuxeo.runtime.api.Framework;

public class MailSessionBuilder {
    private static final Logger log = LogManager.getLogger(MailSessionBuilder.class);

    public static FromBuilder fromNuxeoConf() {
        Properties frameworkProperties = Framework.getProperties();
        Properties properties = frameworkProperties.stringPropertyNames().stream().filter(key -> key.startsWith("mail.")).collect(Collectors.toMap(Function.identity(), frameworkProperties::getProperty, (v1, v2) -> v2, Properties::new));
        return MailSessionBuilder.fromJndi(Framework.getProperty((String)"jndi.java.mail", (String)"java:comp/env/Mail")).fallbackOn(properties);
    }

    public static FromJndi fromJndi(String jndiSessionName) {
        return new FromJndi(jndiSessionName);
    }

    public static FromProperties fromProperties(Properties properties) {
        return new FromProperties(properties);
    }

    public static interface FromBuilder {
        @NotNull
        public Session build();

        @NotNull
        public Store buildAndConnect();
    }

    protected static abstract class AbstractFrom<F extends AbstractFrom>
    implements FromBuilder {
        protected boolean debug;

        protected AbstractFrom() {
        }

        public F debug() {
            this.debug = true;
            return (F)this;
        }

        @Override
        public Session build() {
            String protocol;
            log.info("Build a javax.mail.Session from builder: {}", (Object)this);
            if (!this.debug) {
                log.trace("Mail log debug enabled by nuxeo.conf");
                this.debug = Boolean.parseBoolean(Framework.getProperty((String)"mail.debug", (String)Boolean.FALSE.toString()));
            }
            Session session = this.retrieveSession();
            if (this.debug) {
                session.setDebugOut(new PrintStream((OutputStream)((Object)new MailLogOutputStream())));
                session.setDebug(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)(protocol = session.getProperty("mail.transport.protocol")))) {
                session.setProtocolForAddress("rfc822", protocol);
            }
            return session;
        }

        protected abstract Session retrieveSession();

        @Override
        public Store buildAndConnect() {
            try {
                Session session = this.build();
                Store store = session.getStore();
                String user = session.getProperty("user");
                String password = session.getProperty("password");
                store.connect(user, password);
                return store;
            }
            catch (MessagingException e) {
                throw new NuxeoException("Unable to build/connect javax.mail.Store", (Throwable)e);
            }
        }
    }

    public static class FromProperties
    extends AbstractFrom<FromProperties> {
        protected Properties properties;

        private FromProperties(Properties properties) {
            this.properties = properties;
            this.debug = properties != null && Boolean.parseBoolean((String)properties.remove("mail.debug"));
        }

        @Override
        protected Session retrieveSession() {
            log.debug("Lookup session from properties: {}", (Object)this.properties);
            return Session.getInstance((Properties)this.properties, (Authenticator)new MailAuthenticator(this.properties));
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            Map<Object, Object> propertiesAsMap = this.properties.entrySet().stream().filter(s -> !s.getKey().toString().contains("password")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.append("properties", propertiesAsMap);
            return builder.toString();
        }
    }

    public static class FromJndi
    extends AbstractFrom<FromJndi> {
        protected String jndiSessionName;

        private FromJndi(String jndiSessionName) {
            this.jndiSessionName = Objects.requireNonNull(jndiSessionName, "jndi Mail Session name is required");
        }

        @Override
        protected Session retrieveSession() {
            try {
                log.debug("Lookup for javax.mail.Session with jndi name: {}", (Object)this.jndiSessionName);
                return (Session)new InitialContext().lookup(this.jndiSessionName);
            }
            catch (NamingException e) {
                throw new NuxeoException((Throwable)e);
            }
        }

        public FromProperties fallbackOn(Properties properties) {
            return new FromProperties(properties){

                @Override
                protected Session retrieveSession() {
                    try {
                        return this.retrieveSession();
                    }
                    catch (NuxeoException e) {
                        log.debug("Lookup failed for javax.mail.Session with jndi name: {}, fallback on properties", (Object)jndiSessionName, (Object)e);
                        return super.retrieveSession();
                    }
                }

                @Override
                public String toString() {
                    return new ToStringBuilder((Object)this).appendToString(this.toString()).appendToString(super.toString()).build();
                }
            };
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("jndiSessionName", (Object)this.jndiSessionName).toString();
        }
    }
}

