/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DescriptorRegistry;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ComponentRegistry;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.util.Watch;

public class ComponentManagerImpl
implements ComponentManager {
    private static final Logger log = LogManager.getLogger(ComponentManagerImpl.class);
    protected final ConcurrentMap<ComponentName, Set<Extension>> pendingExtensions;
    private ListenerList compListeners;
    private Listeners listeners;
    private final ConcurrentMap<String, RegistrationInfo> services;
    protected volatile Set<String> blacklist;
    protected volatile List<RegistrationInfo> started;
    protected volatile List<RegistrationInfo> standby;
    protected volatile Stash stash;
    protected volatile ComponentRegistry registry = new ComponentRegistry();
    protected volatile ComponentRegistry snapshot;
    protected volatile DescriptorRegistry descriptors;
    protected volatile boolean isFlushingStash = false;
    protected volatile boolean changed = false;

    public ComponentManagerImpl(RuntimeService runtime) {
        this.pendingExtensions = new ConcurrentHashMap<ComponentName, Set<Extension>>();
        this.compListeners = new ListenerList();
        this.listeners = new Listeners();
        this.services = new ConcurrentHashMap<String, RegistrationInfo>();
        this.blacklist = new HashSet<String>();
        this.stash = new Stash();
        this.descriptors = new DescriptorRegistry();
    }

    public DescriptorRegistry getDescriptors() {
        return this.descriptors;
    }

    public final ComponentRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Collection<RegistrationInfo> getRegistrations() {
        return this.registry.getComponents();
    }

    @Override
    public Collection<ComponentName> getResolvedRegistrations() {
        return this.registry.getResolvedNames();
    }

    @Override
    public synchronized Map<ComponentName, Set<ComponentName>> getPendingRegistrations() {
        HashMap<ComponentName, Set<ComponentName>> pending = new HashMap<ComponentName, Set<ComponentName>>();
        for (Map.Entry<ComponentName, Set<ComponentName>> p : this.registry.getPendingComponents().entrySet()) {
            pending.put(p.getKey(), new LinkedHashSet(p.getValue()));
        }
        return pending;
    }

    @Override
    public synchronized Map<ComponentName, Set<Extension>> getMissingRegistrations() {
        HashMap<ComponentName, Set<Extension>> missing = new HashMap<ComponentName, Set<Extension>>();
        for (Set p : this.pendingExtensions.values()) {
            for (Extension e : p) {
                missing.computeIfAbsent(e.getComponent().getName(), k -> new LinkedHashSet()).add(e);
            }
        }
        return missing;
    }

    public Set<ComponentName> getNeededRegistrations() {
        return this.pendingExtensions.keySet();
    }

    public Set<Extension> getPendingExtensions(ComponentName name) {
        return (Set)this.pendingExtensions.get(name);
    }

    @Override
    public RegistrationInfo getRegistrationInfo(ComponentName name) {
        return this.registry.getComponent(name);
    }

    @Override
    public boolean isRegistered(ComponentName name) {
        return this.registry.contains(name);
    }

    @Override
    public int size() {
        return this.registry.size();
    }

    @Override
    public ComponentInstance getComponent(ComponentName name) {
        RegistrationInfo ri = this.registry.getComponent(name);
        return ri != null ? ri.getComponent() : null;
    }

    @Override
    public synchronized void shutdown() {
        this.stop();
        this.compListeners = null;
        this.registry.destroy();
        this.registry = null;
        this.snapshot = null;
    }

    @Override
    public Set<String> getBlacklist() {
        return Collections.unmodifiableSet(this.blacklist);
    }

    @Override
    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    @Override
    public synchronized void register(RegistrationInfo ri) {
        ComponentName name = ri.getName();
        if (this.blacklist.contains(name.getName())) {
            log.debug("Component {} was blacklisted. Ignoring.", (Object)name.getName());
            return;
        }
        Set<ComponentName> componentsToRemove = this.stash.toRemove;
        if (!componentsToRemove.contains(name)) {
            if (this.registry.contains(name)) {
                if (name.getName().startsWith("org.nuxeo.runtime.")) {
                    return;
                }
                ComponentManagerImpl.handleError("Duplicate component name: " + name, null);
                return;
            }
            for (ComponentName n : ri.getAliases()) {
                if (!this.registry.contains(n)) continue;
                ComponentManagerImpl.handleError("Duplicate component name: " + n + " (alias for " + name + ")", null);
                return;
            }
        }
        if (this.shouldStash()) {
            this.stash.add(ri);
            return;
        }
        if (this.hasSnapshot()) {
            this.changed = true;
        }
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).attach(this);
        }
        try {
            log.debug("Registering component: {}", (Object)name);
            if (!this.registry.addComponent(ri)) {
                log.info("Registration delayed for component: " + name + ". Waiting for: " + this.registry.getMissingDependencies(ri.getName()));
            }
        }
        catch (RuntimeException e) {
            ComponentManagerImpl.handleError("Failed to register component: " + name + " (" + e.toString() + ')', e);
        }
    }

    @Override
    public synchronized void unregister(RegistrationInfo regInfo) {
        this.unregister(regInfo.getName());
    }

    @Override
    public synchronized void unregister(ComponentName name) {
        if (this.shouldStash()) {
            this.stash.remove(name);
            return;
        }
        if (this.hasSnapshot()) {
            this.changed = true;
        }
        try {
            log.debug("Unregistering component: {}", (Object)name);
            this.registry.removeComponent(name);
        }
        catch (RuntimeException e) {
            log.error("Failed to unregister component: {}", (Object)name, (Object)e);
        }
    }

    @Override
    public synchronized boolean unregisterByLocation(String sourceId) {
        ComponentName name = this.registry.deployedFiles.remove(sourceId);
        if (name != null) {
            this.unregister(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasComponentFromLocation(String sourceId) {
        return this.registry.deployedFiles.containsKey(sourceId);
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.compListeners.add((Object)listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.compListeners.remove((Object)listener);
    }

    @Override
    public void addListener(ComponentManager.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ComponentManager.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public ComponentInstance getComponentProvidingService(Class<?> serviceClass) {
        RegistrationInfo ri = (RegistrationInfo)this.services.get(serviceClass.getName());
        if (ri == null) {
            return null;
        }
        ComponentInstance ci = ri.getComponent();
        if (ci == null) {
            log.debug("The component exposing the service {} is not resolved or not started", serviceClass);
        }
        return ci;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        ComponentInstance comp = this.getComponentProvidingService(serviceClass);
        return comp != null ? (T)comp.getAdapter(serviceClass) : null;
    }

    @Override
    public Collection<ComponentName> getActivatingRegistrations() {
        return this.getRegistrations(3);
    }

    @Override
    public Collection<ComponentName> getStartFailureRegistrations() {
        return this.getRegistrations(6);
    }

    protected Collection<ComponentName> getRegistrations(int state) {
        RegistrationInfo[] comps = this.registry.getComponentsArray();
        ArrayList<ComponentName> ret = new ArrayList<ComponentName>();
        for (RegistrationInfo ri : comps) {
            if (ri.getState() != state) continue;
            ret.add(ri.getName());
        }
        return ret;
    }

    void sendEvent(ComponentEvent event) {
        Object[] listeners;
        log.trace("Dispatching event: {}", (Object)event);
        for (Object listener : listeners = this.compListeners.getListeners()) {
            ((ComponentListener)listener).handleEvent(event);
        }
    }

    public synchronized void registerExtension(Extension extension) {
        ComponentName name = extension.getTargetComponent();
        RegistrationInfo ri = this.registry.getComponent(name);
        if (ri != null && ri.getComponent() != null) {
            log.debug("Register contributed extension: {}", (Object)extension);
            ComponentManagerImpl.loadContributions(ri, extension);
            ri.getComponent().registerExtension(extension);
            this.sendEvent(new ComponentEvent(9, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        } else {
            log.debug("Enqueue contributed extension to pending queue: {}", (Object)extension);
            this.pendingExtensions.computeIfAbsent(name, key -> new LinkedHashSet()).add(extension);
            this.sendEvent(new ComponentEvent(11, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        }
    }

    public synchronized void unregisterExtension(Extension extension) {
        log.debug("Unregister contributed extension: {}", (Object)extension);
        ComponentName name = extension.getTargetComponent();
        RegistrationInfo ri = this.registry.getComponent(name);
        if (ri != null) {
            ComponentInstance co = ri.getComponent();
            if (co != null) {
                co.unregisterExtension(extension);
            }
        } else {
            Set extensions = (Set)this.pendingExtensions.get(name);
            if (extensions != null) {
                extensions.remove(extension);
                if (extensions.isEmpty()) {
                    this.pendingExtensions.remove(name);
                }
            }
        }
        this.sendEvent(new ComponentEvent(10, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
    }

    public static void loadContributions(RegistrationInfo ri, Extension xt) {
        if (ri.useFormerLifecycleManagement()) {
            ri.getExtensionPoint(xt.getExtensionPoint()).filter(xp -> xp.getContributions() != null).map(ExtensionPointImpl.class::cast).ifPresent(xp -> {
                try {
                    Object[] contribs = xp.loadContributions(ri, xt);
                    xt.setContributions(contribs);
                }
                catch (RuntimeException e) {
                    ComponentManagerImpl.handleError("Failed to load contributions for component " + xt.getComponent().getName(), e);
                }
            });
        }
    }

    public synchronized void registerServices(RegistrationInfo ri) {
        String[] serviceNames = ri.getProvidedServiceNames();
        if (serviceNames == null) {
            return;
        }
        for (String serviceName : serviceNames) {
            log.trace("Registering service: {}", (Object)serviceName);
            this.services.put(serviceName, ri);
        }
    }

    public synchronized void unregisterServices(RegistrationInfo ri) {
        String[] serviceNames = ri.getProvidedServiceNames();
        if (serviceNames == null) {
            return;
        }
        for (String service : serviceNames) {
            this.services.remove(service);
        }
    }

    @Override
    public String[] getServices() {
        return this.services.keySet().toArray(new String[0]);
    }

    protected static void handleError(String message, Exception e) {
        log.error(message, (Throwable)e);
        Framework.getRuntime().getMessageHandler().addWarning(message);
    }

    protected List<RegistrationInfo> activateComponents() {
        log.info("Activate components");
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeActivation();
        this.pendingExtensions.clear();
        ArrayList<RegistrationInfo> ris = new ArrayList<RegistrationInfo>();
        for (RegistrationInfo ri : this.registry.getResolvedRegistrationInfo()) {
            watch.start(ri.getName().getName());
            this.activateComponent(ri);
            ris.add(ri);
            watch.stop(ri.getName().getName());
        }
        this.listeners.afterActivation();
        watch.stop();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = watch.total::formatSeconds;
        log.debug("Components activated in {}s", supplierArray);
        this.writeDevMetrics(watch, "activate");
        return ris;
    }

    protected void activateComponent(RegistrationInfo ri) {
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).activate();
            return;
        }
        if (ri.getState() != 2) {
            return;
        }
        ri.setState(3);
        ComponentInstance component = ri.getComponent();
        component.activate();
        log.debug("Component activated: {}", (Object)ri.getName());
        Extension[] extensions = ri.getExtensions();
        if (extensions != null) {
            for (Extension xt : extensions) {
                xt.setComponent(component);
                try {
                    this.registerExtension(xt);
                }
                catch (RuntimeException e) {
                    String msg = "Failed to register extension to: " + xt.getTargetComponent() + ", xpoint: " + xt.getExtensionPoint() + " in component: " + xt.getComponent().getName();
                    log.error(msg, (Throwable)e);
                    msg = msg + " (" + e.toString() + ')';
                    Framework.getRuntime().getMessageHandler().addError(msg);
                }
            }
        }
        Set<ComponentName> aliases = ri.getAliases();
        ArrayList<ComponentName> names = new ArrayList<ComponentName>(1 + aliases.size());
        names.add(ri.getName());
        names.addAll(aliases);
        for (ComponentName n : names) {
            Set pendingExt = (Set)this.pendingExtensions.remove(n);
            if (pendingExt == null) continue;
            for (Extension xt : pendingExt) {
                try {
                    component.registerExtension(xt);
                }
                catch (RuntimeException e) {
                    String msg = "Failed to register extension to: " + xt.getTargetComponent() + ", xpoint: " + xt.getExtensionPoint() + " in component: " + xt.getComponent().getName();
                    log.error(msg, (Throwable)e);
                    msg = msg + " (" + e.toString() + ')';
                    Framework.getRuntime().getMessageHandler().addError(msg);
                }
            }
        }
        this.registerServices(ri);
        ri.setState(5);
    }

    protected void deactivateComponents(boolean isShutdown) {
        log.info("Deactivate components");
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeDeactivation();
        Collection<RegistrationInfo> resolved = this.registry.getResolvedRegistrationInfo();
        ArrayList<RegistrationInfo> reverseResolved = new ArrayList<RegistrationInfo>(resolved);
        Collections.reverse(reverseResolved);
        for (RegistrationInfo ri : reverseResolved) {
            if (!ri.isActivated()) continue;
            watch.start(ri.getName().getName());
            this.deactivateComponent(ri, isShutdown);
            watch.stop(ri.getName().getName());
        }
        this.pendingExtensions.clear();
        this.listeners.afterDeactivation();
        watch.stop();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = watch.total::formatSeconds;
        log.debug("Components deactivated in {}s", supplierArray);
        this.writeDevMetrics(watch, "deactivate");
    }

    protected void deactivateComponent(RegistrationInfo ri, boolean isShutdown) {
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).deactivate(!isShutdown);
            return;
        }
        int state = ri.getState();
        if (state != 5 && state != 6) {
            return;
        }
        ri.setState(4);
        this.unregisterServices(ri);
        Extension[] extensions = ri.getExtensions();
        if (extensions != null) {
            for (Extension xt : extensions) {
                try {
                    this.unregisterExtension(xt);
                }
                catch (RuntimeException e) {
                    String message = "Failed to unregister extension. Contributor: " + xt.getComponent() + " to " + xt.getTargetComponent() + "; xpoint: " + xt.getExtensionPoint();
                    log.error(message, (Throwable)e);
                    Framework.getRuntime().getMessageHandler().addError(message);
                }
            }
        }
        ComponentInstance component = ri.getComponent();
        component.deactivate();
        log.debug("Component deactivated: {}", (Object)ri.getName());
        ri.setState(2);
    }

    protected void startComponents(List<RegistrationInfo> ris, boolean isResume) {
        log.info("Start components (isResume={})", (Object)isResume);
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeStart(isResume);
        for (RegistrationInfo ri : ris) {
            watch.start(ri.getName().getName());
            this.startComponent(ri);
            watch.stop(ri.getName().getName());
        }
        this.started = ris;
        this.listeners.afterStart(isResume);
        watch.stop();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = watch.total::formatSeconds;
        log.debug("Components started in {}s", supplierArray);
        this.writeDevMetrics(watch, "start");
    }

    protected void startComponent(RegistrationInfo ri) {
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).start();
            return;
        }
        if (ri.getState() != 5) {
            return;
        }
        try {
            ri.setState(8);
            ComponentInstance component = ri.getComponent();
            component.start();
            log.debug("Component started: {}", (Object)ri.getName());
            ri.setState(7);
        }
        catch (RuntimeException e) {
            log.error("Component {} notification of application started failed: {}", (Object)ri.getName(), (Object)e.getMessage(), (Object)e);
            ri.setState(6);
        }
    }

    protected void stopComponents(boolean isStandby) {
        log.info("Stop components (isStandby={})", (Object)isStandby);
        try {
            Watch watch = new Watch();
            watch.start();
            this.listeners.beforeStop(isStandby);
            List<RegistrationInfo> list = this.started;
            for (int i = list.size() - 1; i >= 0; --i) {
                RegistrationInfo ri = list.get(i);
                if (!ri.isStarted()) continue;
                watch.start(ri.getName().getName());
                this.stopComponent(ri);
                watch.stop(ri.getName().getName());
            }
            this.listeners.afterStop(isStandby);
            watch.stop();
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = watch.total::formatSeconds;
            log.debug("Components stopped in {}s", supplierArray);
            this.writeDevMetrics(watch, "stop");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while stopping components", e);
        }
    }

    protected void stopComponent(RegistrationInfo ri) throws InterruptedException {
        if (ri.useFormerLifecycleManagement()) {
            ((RegistrationInfoImpl)ri).stop();
            return;
        }
        if (ri.getState() != 7) {
            return;
        }
        ri.setState(9);
        ComponentInstance component = ri.getComponent();
        component.stop();
        log.debug("Component stopped: {}", (Object)ri.getName());
        ri.setState(2);
    }

    @Override
    public synchronized boolean start() {
        if (this.started != null) {
            return false;
        }
        log.info("Starting Nuxeo Components");
        List<RegistrationInfo> ris = this.activateComponents();
        ris.sort(new RIApplicationStartedComparator());
        this.startComponents(ris, false);
        return true;
    }

    @Override
    public synchronized boolean stop() {
        if (this.started == null) {
            return false;
        }
        log.info("Stopping Nuxeo Components");
        try {
            this.stopComponents(false);
            this.deactivateComponents(true);
        }
        finally {
            this.started = null;
        }
        return true;
    }

    @Override
    public void stop(int timeoutInSeconds) {
        try {
            ComponentManagerImpl.runWihtinTimeout(timeoutInSeconds, TimeUnit.SECONDS, "Timed out on stop, blocking", this::stop);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while stopping components", e);
        }
    }

    @Override
    public synchronized void standby() {
        if (this.started != null) {
            try {
                this.stopComponents(true);
            }
            finally {
                this.standby = this.started;
                this.started = null;
            }
        }
    }

    @Override
    public void standby(int timeoutInSeconds) {
        try {
            ComponentManagerImpl.runWihtinTimeout(timeoutInSeconds, TimeUnit.SECONDS, "Timed out on standby, blocking", this::standby);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while standbying components", e);
        }
    }

    @Override
    public synchronized void resume() {
        if (this.standby != null) {
            try {
                this.startComponents(this.standby, true);
            }
            finally {
                this.started = this.standby;
                this.standby = null;
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started != null;
    }

    @Override
    public boolean isStandby() {
        return this.standby != null;
    }

    @Override
    public boolean isRunning() {
        return this.started != null || this.standby != null;
    }

    @Override
    public boolean hasSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public synchronized void snapshot() {
        this.snapshot = new ComponentRegistry(this.registry);
    }

    @Override
    public boolean isStashEmpty() {
        return this.stash.isEmpty();
    }

    @Override
    public synchronized void restart(boolean reset) {
        if (reset) {
            this.reset();
        } else {
            this.stop();
        }
        this.start();
    }

    @Override
    public synchronized boolean reset() {
        boolean r = this.stop();
        this.restoreSnapshot();
        return r;
    }

    @Override
    public synchronized boolean refresh() {
        return this.refresh(false);
    }

    @Override
    public synchronized boolean refresh(boolean reset) {
        if (this.stash.isEmpty()) {
            return false;
        }
        boolean requireStart = reset ? this.reset() : this.stop();
        Stash currentStash = this.stash;
        this.stash = new Stash();
        this.applyStash(currentStash);
        if (requireStart) {
            this.start();
        }
        return true;
    }

    protected synchronized void restoreSnapshot() {
        if (this.changed && this.snapshot != null) {
            log.info("Restoring components snapshot");
            this.registry = new ComponentRegistry(this.snapshot);
            this.changed = false;
        }
    }

    protected boolean shouldStash() {
        return this.isRunning() && !this.isFlushingStash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void applyStash(Stash stash) {
        log.debug("Applying stashed components");
        this.isFlushingStash = true;
        try {
            for (ComponentName name : stash.toRemove) {
                this.unregister(name);
            }
            for (RegistrationInfo ri : stash.toAdd) {
                this.register(ri);
            }
        }
        finally {
            this.isFlushingStash = false;
        }
    }

    @Override
    public synchronized void unstash() {
        Stash currentStash = this.stash;
        this.stash = new Stash();
        if (!this.isRunning()) {
            this.applyStash(currentStash);
        } else {
            try {
                this.applyStashWhenRunning(currentStash);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while unstashing components", e);
            }
        }
    }

    private void applyStashWhenRunning(Stash stash) throws InterruptedException {
        List<RegistrationInfo> toRemove = stash.getRegistrationsToRemove(this.registry);
        if (this.isStarted()) {
            for (RegistrationInfo ri : toRemove) {
                this.started.remove(ri);
                this.stopComponent(ri);
            }
        }
        for (RegistrationInfo ri : toRemove) {
            if (this.isStandby()) {
                this.standby.remove(ri);
            }
            this.deactivateComponent(ri, false);
        }
        this.applyStash(stash);
        for (RegistrationInfo ri : stash.toAdd) {
            if (!ri.isResolved()) continue;
            this.activateComponent(ri);
            if (!this.isStandby()) continue;
            this.standby.add(ri);
        }
        if (this.isStarted()) {
            for (RegistrationInfo ri : stash.toAdd) {
                if (!ri.isActivated()) continue;
                this.startComponent(ri);
                this.started.add(ri);
            }
        }
    }

    protected void writeDevMetrics(Watch watch, String type) {
        if (!Framework.isDevModeSet()) {
            return;
        }
        File file = new File(Environment.getDefault().getTemp(), type + "-metrics.txt");
        try (PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");){
            ps.println(watch.getTotal());
            Arrays.stream(watch.getIntervals()).sorted(Comparator.reverseOrder()).forEach(ps::println);
            ps.flush();
        }
        catch (IOException e) {
            log.error("Failed to write metrics file: {}", (Object)file, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runWihtinTimeout(long timeout, TimeUnit unit, String warn, Runnable runnable) throws InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executor.submit(runnable::run);
            executor.shutdown();
            try {
                try {
                    future.get(timeout, unit);
                }
                catch (TimeoutException cause) {
                    log.warn(warn);
                    future.get();
                }
            }
            catch (ExecutionException cause) {
                throw new RuntimeException("Errors caught while stopping components, giving up", cause);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    protected static class Stash {
        protected volatile List<RegistrationInfo> toAdd = new ArrayList<RegistrationInfo>();
        protected volatile Set<ComponentName> toRemove = new HashSet<ComponentName>();

        public void add(RegistrationInfo ri) {
            this.toAdd.add(ri);
        }

        public void remove(ComponentName name) {
            this.toRemove.add(name);
        }

        public boolean isEmpty() {
            return this.toAdd.isEmpty() && this.toRemove.isEmpty();
        }

        public List<RegistrationInfo> getRegistrationsToRemove(ComponentRegistry reg) {
            ArrayList<RegistrationInfo> ris = new ArrayList<RegistrationInfo>();
            for (ComponentName name : this.toRemove) {
                RegistrationInfo ri = reg.getComponent(name);
                if (ri == null) continue;
                ris.add(ri);
            }
            return ris;
        }
    }

    protected class Listeners {
        protected ListenerList listeners = new ListenerList();

        protected Listeners() {
        }

        public void add(ComponentManager.Listener listener) {
            this.listeners.add((Object)listener);
        }

        public void remove(ComponentManager.Listener listener) {
            this.listeners.remove((Object)listener);
        }

        public void beforeActivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeActivation(ComponentManagerImpl.this);
            }
        }

        public void afterActivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterActivation(ComponentManagerImpl.this);
            }
        }

        public void beforeDeactivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeDeactivation(ComponentManagerImpl.this);
            }
        }

        public void afterDeactivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterDeactivation(ComponentManagerImpl.this);
            }
        }

        public void beforeStart(boolean isResume) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeStart(ComponentManagerImpl.this, isResume);
            }
        }

        public void afterStart(boolean isResume) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterStart(ComponentManagerImpl.this, isResume);
            }
        }

        public void beforeStop(boolean isStandby) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeStop(ComponentManagerImpl.this, isStandby);
            }
        }

        public void afterStop(boolean isStandby) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterStop(ComponentManagerImpl.this, isStandby);
            }
        }
    }

    protected static class RIApplicationStartedComparator
    implements Comparator<RegistrationInfo> {
        protected RIApplicationStartedComparator() {
        }

        @Override
        public int compare(RegistrationInfo r1, RegistrationInfo r2) {
            int cmp = Integer.compare(r1.getApplicationStartedOrder(), r2.getApplicationStartedOrder());
            if (cmp == 0) {
                cmp = r1.getName().getName().compareTo(r2.getName().getName());
            }
            return cmp;
        }
    }
}

