/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;

public class BackingServiceConfigurator {
    protected static final Log log = LogFactory.getLog(BackingServiceConfigurator.class);
    public static final String PARAM_RETRY_POLICY_ENABLED = "nuxeo.backing.check.retry.enabled";
    public static final String PARAM_RETRY_POLICY_MAX_RETRIES = "nuxeo.backing.check.retry.maxRetries";
    public static final String PARAM_RETRY_POLICY_DELAY_IN_MS = "nuxeo.backing.check.retry.delayInMs";
    public static final String PARAM_POLICY_DEFAULT_DELAY_IN_MS = "5000";
    public static final String PARAM_RETRY_POLICY_DEFAULT_RETRIES = "20";
    public static final String PARAM_CHECK_CLASSPATH_SUFFIX = ".check.classpath";
    public static final String PARAM_CHECK_SUFFIX = ".check.class";
    protected static final String JAR_EXTENSION = ".jar";
    protected Set<BackingChecker> checkers;
    protected ConfigurationGenerator configurationGenerator;

    public BackingServiceConfigurator(ConfigurationGenerator configurationGenerator) {
        this.configurationGenerator = configurationGenerator;
    }

    public void verifyInstallation() throws ConfigurationException {
        RetryPolicy retryPolicy = this.buildRetryPolicy();
        for (BackingChecker checker : this.getCheckers()) {
            if (!checker.accepts(this.configurationGenerator)) continue;
            try {
                ((SyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)retryPolicy).onFailedAttempt(failure -> log.error((Object)failure.getMessage()))).onRetry((c, f, ctx) -> log.warn((Object)String.format("Failure %d. Retrying....", ctx.getExecutions())))).run(() -> checker.check(this.configurationGenerator));
            }
            catch (FailsafeException e) {
                if (e.getCause() instanceof ConfigurationException) {
                    throw (ConfigurationException)e.getCause();
                }
                throw e;
            }
        }
    }

    protected RetryPolicy buildRetryPolicy() {
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(0);
        CryptoProperties userConfig = this.configurationGenerator.getUserConfig();
        if (Boolean.parseBoolean(userConfig.getProperty(PARAM_RETRY_POLICY_ENABLED, "false"))) {
            int maxRetries = Integer.parseInt(userConfig.getProperty(PARAM_RETRY_POLICY_MAX_RETRIES, PARAM_RETRY_POLICY_DEFAULT_RETRIES));
            int delay = Integer.parseInt(userConfig.getProperty(PARAM_RETRY_POLICY_DELAY_IN_MS, PARAM_POLICY_DEFAULT_DELAY_IN_MS));
            retryPolicy = retryPolicy.retryOn(ConfigurationException.class).withMaxRetries(maxRetries).withDelay((long)delay, TimeUnit.MILLISECONDS);
        }
        return retryPolicy;
    }

    protected Collection<BackingChecker> getCheckers() throws ConfigurationException {
        if (this.checkers == null) {
            this.checkers = new HashSet<BackingChecker>();
            for (String template : this.configurationGenerator.getTemplateList()) {
                try {
                    File templateDir = this.configurationGenerator.getTemplateConf(template).getParentFile();
                    String classPath = this.getClasspathForTemplate(template);
                    String checkClass = this.configurationGenerator.getUserConfig().getProperty(template + PARAM_CHECK_SUFFIX);
                    Optional<URLClassLoader> ucl = this.getClassLoaderForTemplate(templateDir, classPath);
                    if (!ucl.isPresent()) continue;
                    Class<?> klass = Class.forName(checkClass, true, ucl.get());
                    this.checkers.add((BackingChecker)klass.newInstance());
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to read check configuration for template : " + template), (Throwable)e);
                }
                catch (ClassCastException | ReflectiveOperationException e) {
                    throw new ConfigurationException("Unable to check configuration for backing service " + template, e);
                }
            }
        }
        return this.checkers;
    }

    String getClasspathForTemplate(String template) {
        String classPath = this.configurationGenerator.getUserConfig().getProperty(template + PARAM_CHECK_CLASSPATH_SUFFIX);
        TextTemplate templateParser = new TextTemplate((Properties)this.configurationGenerator.getUserConfig());
        return templateParser.processText(classPath);
    }

    protected Optional<URLClassLoader> getClassLoaderForTemplate(File templateDir, String classPath) throws ConfigurationException, IOException {
        if (StringUtils.isBlank((CharSequence)classPath)) {
            return Optional.empty();
        }
        String[] classpathEntries = classPath.split(":");
        ArrayList<URL> urlsList = new ArrayList<URL>();
        ArrayList<File> files = new ArrayList<File>();
        for (String entry : classpathEntries) {
            files.addAll(this.getJarsFromClasspathEntry(templateDir.toPath(), entry));
        }
        if (!files.isEmpty()) {
            for (File file : files) {
                try {
                    urlsList.add(new URL("jar:file:" + file.getPath() + "!/"));
                    log.debug((Object)("Added " + file.getPath()));
                }
                catch (MalformedURLException e) {
                    log.error((Object)e);
                }
            }
        } else {
            return Optional.empty();
        }
        URLClassLoader ucl = new URLClassLoader(urlsList.toArray(new URL[0]));
        return Optional.of(ucl);
    }

    Collection<File> getJarsFromClasspathEntry(Path templatePath, String entry) {
        PathMatcher matcher;
        ArrayList<File> jars = new ArrayList<File>();
        String path = new File(entry = entry.replace("/", File.separator)).isAbsolute() ? entry : templatePath.toString() + File.separator + entry;
        int slashIndex = path.lastIndexOf(File.separator);
        if (slashIndex == -1) {
            return Collections.emptyList();
        }
        String dirName = path.substring(0, slashIndex);
        File parentDir = new File(dirName);
        File[] realMatchingFiles = parentDir.listFiles(arg_0 -> this.lambda$getJarsFromClasspathEntry$3(matcher = FileSystems.getDefault().getPathMatcher("glob:" + path), arg_0));
        if (realMatchingFiles != null) {
            for (File file : realMatchingFiles) {
                if (file.isDirectory()) {
                    jars.addAll(Arrays.asList(file.listFiles(f -> f.getName().endsWith(JAR_EXTENSION))));
                    continue;
                }
                if (!file.getName().endsWith(JAR_EXTENSION)) continue;
                jars.add(file);
            }
        }
        return jars;
    }

    private /* synthetic */ boolean lambda$getJarsFromClasspathEntry$3(PathMatcher matcher, File f) {
        return matcher.matches(f.toPath()) && f.toPath().startsWith(this.configurationGenerator.getNuxeoHome().toPath());
    }
}

