/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.ServerConfigurator;

public class JettyConfigurator
extends ServerConfigurator {
    public static final String JETTY_CONFIG = "config/sql.properties";
    public static final String LAUNCHER_CLASS = "org.nuxeo.runtime.launcher.Main";
    public static final String STARTUP_CLASS = "org.nuxeo.osgi.application.Main";
    public static final String JETTY_HOME = "jetty.home";

    public JettyConfigurator(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
        log.info((Object)"Detected Jetty server.");
    }

    @Override
    protected boolean isConfigured() {
        return new File(this.generator.getNuxeoHome(), JETTY_CONFIG).exists();
    }

    @Override
    public void checkPaths() throws ConfigurationException {
        super.checkPaths();
    }

    @Override
    public File getLogConfFile() {
        return new File(this.getConfigDir(), "log4j2.xml");
    }

    @Override
    public File getConfigDir() {
        return new File(this.generator.getNuxeoHome(), "config");
    }

    @Override
    protected File getRuntimeHome() {
        return this.generator.getNuxeoHome();
    }

    @Override
    public File getServerLibDir() {
        return this.getNuxeoLibDir();
    }
}

