/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.runtime.api.Framework;

public class ExportedDocumentImpl
implements ExportedDocument {
    private static final Random RANDOM = new SecureRandom();
    protected DocumentLocation srcLocation;
    protected String id;
    protected Path path;
    protected Document document;
    protected final Map<String, Blob> blobs = new HashMap<String, Blob>(4);
    protected final Map<String, Document> documents = new HashMap<String, Document>(4);

    public ExportedDocumentImpl() {
    }

    public ExportedDocumentImpl(DocumentModel doc, Path path, boolean inlineBlobs) throws IOException {
        this.id = doc.getId();
        this.path = path == null ? new Path("") : path.makeRelative();
        this.readDocument(doc, inlineBlobs);
        this.srcLocation = new DocumentLocationImpl(doc);
    }

    public ExportedDocumentImpl(DocumentModel doc) throws IOException {
        this(doc, false);
    }

    public ExportedDocumentImpl(DocumentModel doc, boolean inlineBlobs) throws IOException {
        this(doc, doc.getPath(), inlineBlobs);
    }

    @Override
    public DocumentLocation getSourceLocation() {
        return this.srcLocation;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void setPath(Path path) {
        this.path = path;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.document.getRootElement().element("system").elementText("type");
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
        this.id = document.getRootElement().attributeValue("id");
        String repName = document.getRootElement().attributeValue("repository");
        this.srcLocation = new DocumentLocationImpl(repName, (DocumentRef)new IdRef(this.id));
    }

    @Override
    public Map<String, Blob> getBlobs() {
        return this.blobs;
    }

    @Override
    public void putBlob(String blobId, Blob blob) {
        this.blobs.put(blobId, blob);
    }

    @Override
    public Blob removeBlob(String blobId) {
        return this.blobs.remove(blobId);
    }

    @Override
    public Blob getBlob(String blobId) {
        return this.blobs.get(blobId);
    }

    @Override
    public boolean hasExternalBlobs() {
        return !this.blobs.isEmpty();
    }

    @Override
    public Map<String, Document> getDocuments() {
        return this.documents;
    }

    @Override
    public Document getDocument(String docId) {
        return this.documents.get(docId);
    }

    @Override
    public void putDocument(String docId, Document doc) {
        this.documents.put(docId, doc);
    }

    @Override
    public Document removeDocument(String docId) {
        return this.documents.remove(docId);
    }

    @Override
    public int getFilesCount() {
        return 1 + this.documents.size() + this.blobs.size();
    }

    protected void readDocument(DocumentModel doc, boolean inlineBlobs) throws IOException {
        this.document = DocumentFactory.getInstance().createDocument();
        this.document.setName(doc.getName());
        Element rootElement = this.document.addElement("document");
        rootElement.addAttribute("repository", doc.getRepositoryName());
        rootElement.addAttribute("id", doc.getRef().toString());
        Element systemElement = rootElement.addElement("system");
        systemElement.addElement("type").addText(doc.getType());
        systemElement.addElement("path").addText(this.path.toString());
        this.readLifeCycleInfo(systemElement, doc);
        this.readFacets(systemElement, doc);
        Element acpElement = systemElement.addElement("access-control");
        ACP acp = doc.getACP();
        if (acp != null) {
            ExportedDocumentImpl.readACP(acpElement, acp);
        }
        this.readDocumentSchemas(rootElement, doc, inlineBlobs);
    }

    protected void readLifeCycleInfo(Element element, DocumentModel doc) {
        String lifeCyclePolicy;
        String lifeCycleState = doc.getCurrentLifeCycleState();
        if (lifeCycleState != null && lifeCycleState.length() > 0) {
            element.addElement("lifecycle-state").addText(lifeCycleState);
        }
        if ((lifeCyclePolicy = doc.getLifeCyclePolicy()) != null && lifeCyclePolicy.length() > 0) {
            element.addElement("lifecycle-policy").addText(lifeCyclePolicy);
        }
    }

    protected void readFacets(Element element, DocumentModel doc) {
        for (String facet : doc.getFacets()) {
            element.addElement("facet").addText(facet);
        }
    }

    protected void readDocumentSchemas(Element element, DocumentModel doc, boolean inlineBlobs) throws IOException {
        String[] schemaNames;
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (String schemaName : schemaNames = doc.getSchemas()) {
            Element schemaElement = element.addElement("schema").addAttribute("name", schemaName);
            Schema schema = schemaManager.getSchema(schemaName);
            Namespace targetNs = schema.getNamespace();
            if (StringUtils.isEmpty((CharSequence)targetNs.prefix)) {
                targetNs = new Namespace(targetNs.uri, schema.getName());
            }
            schemaElement.addNamespace(targetNs.prefix, targetNs.uri);
            DataModel dataModel = doc.getDataModel(schemaName);
            for (Field field : schema.getFields()) {
                Object value = dataModel.getData(field.getName().getLocalName());
                this.readProperty(schemaElement, targetNs, field, value, inlineBlobs);
            }
        }
    }

    protected void readProperty(Element parent, Namespace targetNs, Field field, Object value, boolean inlineBlobs) throws IOException {
        if (value == null) {
            return;
        }
        Type type = field.getType();
        QName name = QName.get((String)field.getName().getLocalName(), (String)targetNs.prefix, (String)targetNs.uri);
        Element element = parent.addElement(name);
        if (type.isSimpleType()) {
            String encodedValue = type.encode(value);
            if (encodedValue != null) {
                encodedValue = encodedValue.replaceAll("]]>", "]]]]><![CDATA[>");
            }
            element.addCDATA(encodedValue);
        } else if (type.isComplexType()) {
            ComplexType ctype = (ComplexType)type;
            if (TypeConstants.isContentType((Type)ctype)) {
                this.readBlob(element, ctype, (Blob)value, inlineBlobs);
            } else {
                this.readComplex(element, ctype, (Map)value, inlineBlobs);
            }
        } else if (type.isListType()) {
            if (value instanceof List) {
                this.readList(element, (ListType)type, (List)value, inlineBlobs);
            } else if (value.getClass().getComponentType() != null) {
                this.readList(element, (ListType)type, PrimitiveArrays.toList((Object)value), inlineBlobs);
            } else {
                throw new IllegalArgumentException("A value of list type is neither list neither array: " + value);
            }
        }
    }

    protected final void readBlob(Element element, ComplexType ctype, Blob blob, boolean inlineBlobs) throws IOException {
        String blobPath = Integer.toHexString(RANDOM.nextInt()) + ".blob";
        element.addElement("encoding").addText(blob.getEncoding() != null ? blob.getEncoding() : "");
        element.addElement("mime-type").addText(blob.getMimeType() != null ? blob.getMimeType() : "");
        element.addElement("filename").addText(blob.getFilename() != null ? blob.getFilename() : "");
        Element data = element.addElement("data");
        if (inlineBlobs) {
            String content = Base64.encodeBase64String((byte[])blob.getByteArray());
            data.setText(content);
        } else {
            data.setText(blobPath);
            this.blobs.put(blobPath, blob);
        }
        element.addElement("digest").addText(blob.getDigest() != null ? blob.getDigest() : "");
    }

    protected final void readComplex(Element element, ComplexType ctype, Map map, boolean inlineBlobs) throws IOException {
        for (Map.Entry entry : map.entrySet()) {
            this.readProperty(element, ctype.getNamespace(), ctype.getField(entry.getKey().toString()), entry.getValue(), inlineBlobs);
        }
    }

    protected final void readList(Element element, ListType ltype, List list, boolean inlineBlobs) throws IOException {
        Field field = ltype.getField();
        for (Object obj : list) {
            this.readProperty(element, Namespace.DEFAULT_NS, field, obj, inlineBlobs);
        }
    }

    protected static void readACP(Element element, ACP acp) {
        ACL[] acls;
        for (ACL acl : acls = acp.getACLs()) {
            ACE[] aces;
            Element aclElement = element.addElement("acl");
            aclElement.addAttribute("name", acl.getName());
            for (ACE ace : aces = acl.getACEs()) {
                Calendar end;
                Element aceElement = aclElement.addElement("entry");
                aceElement.addAttribute("principal", ace.getUsername());
                aceElement.addAttribute("permission", ace.getPermission());
                aceElement.addAttribute("grant", String.valueOf(ace.isGranted()));
                aceElement.addAttribute("creator", ace.getCreator());
                Calendar begin = ace.getBegin();
                if (begin != null) {
                    aceElement.addAttribute("begin", DateParser.formatW3CDateTime((Date)begin.getTime()));
                }
                if ((end = ace.getEnd()) == null) continue;
                aceElement.addAttribute("end", DateParser.formatW3CDateTime((Date)end.getTime()));
            }
        }
    }
}

