/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentTreeIterator;
import org.nuxeo.ecm.core.io.ExportExtension;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelReader;

public class ExtensibleDocumentTreeReader
extends DocumentModelReader {
    protected DocumentTreeIterator iterator;
    protected int pathSegmentsToRemove = 0;
    protected List<DocumentModel> pendingVersions = new LinkedList<DocumentModel>();
    protected List<ExportExtension> extensions = new ArrayList<ExportExtension>();
    public static final String VERSION_VIRTUAL_PATH_SEGMENT = "__versions__";

    public ExtensibleDocumentTreeReader(CoreSession session, DocumentModel root, boolean excludeRoot) {
        super(session);
        this.iterator = new DocumentTreeIterator(session, root, excludeRoot);
        this.pathSegmentsToRemove = root.getPath().segmentCount() - (excludeRoot ? 0 : 1);
    }

    public ExtensibleDocumentTreeReader(CoreSession session, DocumentRef root) {
        this(session, session.getDocument(root));
    }

    public ExtensibleDocumentTreeReader(CoreSession session, DocumentModel root) {
        this(session, root, false);
    }

    public void registerExtension(ExportExtension ext) {
        this.extensions.add(ext);
    }

    @Override
    public void close() {
        super.close();
        this.iterator.reset();
        this.iterator = null;
    }

    @Override
    public ExportedDocument read() throws IOException {
        DocumentModel docModel = null;
        if (this.pendingVersions.size() > 0) {
            docModel = this.pendingVersions.remove(0);
        } else if (this.iterator.hasNext()) {
            docModel = this.iterator.next();
            try {
                List versions = this.session.getVersions(docModel.getRef());
                if (!versions.isEmpty()) {
                    this.pendingVersions.addAll(0, versions);
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to get versions", e);
            }
        }
        ExportedDocumentImpl result = null;
        if (docModel != null) {
            result = this.pathSegmentsToRemove > 0 ? new ExportedDocumentImpl(docModel, docModel.getPath().removeFirstSegments(this.pathSegmentsToRemove), this.inlineBlobs) : new ExportedDocumentImpl(docModel, this.inlineBlobs);
            if (docModel.isVersion()) {
                Path path = docModel.getPath().append(VERSION_VIRTUAL_PATH_SEGMENT).append(docModel.getVersionLabel());
                if (this.pathSegmentsToRemove > 0) {
                    path = path.removeFirstSegments(this.pathSegmentsToRemove);
                }
                result.setPath(path);
            }
            try {
                for (ExportExtension ext : this.extensions) {
                    ext.updateExport(docModel, result);
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to process versions", e);
            }
        }
        return result;
    }
}

