/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.transformers;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.schema.PropertyDeprecationHandler;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class PropertyDeprecationRemover
implements DocumentTransformer {
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
    protected final PropertyDeprecationHandler removeHandler = this.schemaManager.getRemovedProperties();

    @Override
    public boolean transform(ExportedDocument xdoc) throws IOException {
        Element root = xdoc.getDocument().getRootElement();
        for (Element schema : root.elements("schema")) {
            String schemaName = schema.attributeValue("name");
            if (!this.removeHandler.hasMarkedProperties(schemaName)) continue;
            Set props = this.removeHandler.getProperties(schemaName);
            for (String prop : props) {
                this.handleProperty(schema, prop);
            }
        }
        return true;
    }

    protected void handleProperty(Element schema, String propertyToRemove) {
        int starIndex;
        String schemaName = schema.attributeValue("name");
        String namespaceURI = "http://www.nuxeo.org/ecm/schemas/" + schemaName + '/';
        String schemaPrefix = Optional.ofNullable(schema.getNamespaceForURI(namespaceURI)).map(Namespace::getPrefix).filter(StringUtils::isNotBlank).map(p -> p + ':').orElse("");
        String fallback = this.removeHandler.getFallback(schemaName, propertyToRemove);
        Field fallbackField = this.schemaManager.getField(schemaPrefix + fallback);
        if (fallbackField != null && TypeConstants.isContentType((Type)fallbackField.getDeclaringType())) {
            fallback = fallback.replace("/name", "/filename");
        }
        if ((starIndex = propertyToRemove.indexOf(42)) < 0) {
            Element elementToRemove = (Element)schema.selectSingleNode(schemaPrefix + propertyToRemove);
            if (elementToRemove != null) {
                this.moveAndDetachProperty(schema, schema, elementToRemove, fallback);
            }
        } else {
            List elementsToRemove = schema.selectNodes(schemaPrefix + propertyToRemove);
            int count = StringUtils.countMatches((CharSequence)propertyToRemove.substring(starIndex), (CharSequence)"/");
            String newFallback = fallback;
            if (newFallback != null) {
                newFallback = newFallback.substring(newFallback.lastIndexOf("*/") + 2);
            }
            Iterator iterator = elementsToRemove.iterator();
            while (iterator.hasNext()) {
                Element elementToRemove;
                Element parent = elementToRemove = (Element)iterator.next();
                for (int i = 0; i < count; ++i) {
                    parent = parent.getParent();
                }
                this.moveAndDetachProperty(schema, parent, elementToRemove, newFallback);
            }
        }
    }

    protected void moveAndDetachProperty(Element schema, Element parent, Element elementToRemove, String fallback) {
        if (fallback != null) {
            String[] fallbackSegments;
            for (String fallbackSegment : fallbackSegments = fallback.split("/")) {
                QName qName = parent == schema ? QName.get((String)fallbackSegment, (Namespace)schema.getNamespaceForPrefix(schema.attributeValue("name"))) : QName.get((String)fallbackSegment);
                Element element = parent.element(qName);
                if (element == null) {
                    element = DocumentHelper.createElement((QName)qName);
                    parent.add(element);
                }
                parent = element;
            }
            if (!parent.hasContent()) {
                parent.setContent(elementToRemove.content());
            }
        }
        elementToRemove.detach();
    }
}

