/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonReader;
import org.nuxeo.ecm.core.io.registry.MarshallingException;

public abstract class EntityJsonReader<EntityType>
extends AbstractJsonReader<EntityType> {
    private final String entityType;

    public EntityJsonReader(String entityType) {
        this.entityType = entityType;
    }

    @Override
    public final EntityType read(JsonNode jn) throws IOException {
        if (!jn.isObject()) {
            throw new MarshallingException("Json does not contain an object as expected");
        }
        JsonNode entityNode = jn.get("entity-type");
        if (entityNode == null || entityNode.isNull() || !entityNode.isTextual()) {
            throw new MarshallingException("Json object does not contain an entity-type field as expected");
        }
        String entityValue = entityNode.textValue();
        if (!this.entityType.equals(entityValue)) {
            throw new MarshallingException("Json object entity-type is wrong. Expected is " + this.entityType + " but was " + entityValue);
        }
        return this.readEntity(jn);
    }

    protected abstract EntityType readEntity(JsonNode var1) throws IOException;
}

