/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.Enriched;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.context.WrappedContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentPropertyJsonWriter
extends AbstractJsonWriter<Property> {
    public static final String OMIT_PHANTOM_SECURED_PROPERTY = "omitPhantomSecuredProperty";
    private static final Log log = LogFactory.getLog(DocumentPropertyJsonWriter.class);

    @Override
    public void write(Property prop, JsonGenerator jg) throws IOException {
        this.writeProperty(jg, prop);
        jg.flush();
    }

    protected void writeProperty(JsonGenerator jg, Property prop) throws IOException {
        if (prop.isScalar()) {
            this.writeScalarProperty(jg, prop);
        } else if (prop.isList()) {
            this.writeListProperty(jg, prop);
        } else if (prop instanceof BlobProperty) {
            this.writeBlobProperty(jg, (BlobProperty)prop);
        } else if (prop.isComplex()) {
            this.writeComplexProperty(jg, prop);
        } else if (prop.isPhantom()) {
            jg.writeNull();
        }
    }

    protected void writeScalarProperty(JsonGenerator jg, Property prop) throws IOException {
        org.nuxeo.ecm.core.schema.types.Type type = prop.getType();
        Serializable value = prop.getValue();
        if (!this.fetchProperty(jg, prop.getType().getObjectResolver(), value, prop.getXPath())) {
            this.writeScalarPropertyValue(jg, (org.nuxeo.ecm.core.schema.types.Type)((SimpleType)type).getPrimitiveType(), value);
        }
    }

    private void writeScalarPropertyValue(JsonGenerator jg, org.nuxeo.ecm.core.schema.types.Type type, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else if (type instanceof BooleanType) {
            jg.writeBoolean(((Boolean)value).booleanValue());
        } else if (type instanceof LongType) {
            jg.writeNumber(((Number)value).longValue());
        } else if (type instanceof DoubleType) {
            jg.writeNumber(((Double)value).doubleValue());
        } else if (type instanceof IntegerType) {
            jg.writeNumber(((Integer)value).intValue());
        } else if (type instanceof BinaryType) {
            jg.writeBinary((byte[])value);
        } else {
            jg.writeString(type.encode(value));
        }
    }

    protected boolean fetchProperty(JsonGenerator jg, ObjectResolver resolver, Object value, String path) throws IOException {
        if (value == null) {
            return false;
        }
        boolean fetched = false;
        if (resolver != null) {
            DocumentModel doc;
            CoreSession context;
            Object object;
            String genericPropertyPath = path.replaceAll("/[0-9]*/", "/*/");
            Set<String> fetchElements = this.ctx.getFetched("document");
            boolean fetch = false;
            for (String fetchElement : fetchElements) {
                if (!"properties".equals(fetchElement) && !path.startsWith(fetchElement) && !genericPropertyPath.startsWith(fetchElement)) continue;
                fetch = true;
                break;
            }
            if (fetch && (object = resolver.fetch(value, (Object)(context = (doc = (DocumentModel)this.ctx.getParameter("document")) == null ? null : doc.getCoreSession()))) != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.writeEntity(object, baos);
                    jg.writeRawValue(baos.toString());
                    fetched = true;
                }
                catch (MarshallingException e) {
                    log.error((Object)("Unable to marshall as json the entity referenced by the property " + path), (Throwable)((Object)e));
                }
            }
        }
        return fetched;
    }

    protected void writeListProperty(JsonGenerator jg, Property prop) throws IOException {
        jg.writeStartArray();
        if (prop instanceof ArrayProperty) {
            Object[] ar = (Object[])prop.getValue();
            if (ar == null) {
                jg.writeEndArray();
                return;
            }
            org.nuxeo.ecm.core.schema.types.Type itemType = ((ListType)prop.getType()).getFieldType();
            ObjectResolver resolver = itemType.getObjectResolver();
            String path = prop.getXPath();
            for (Object o : ar) {
                if (this.fetchProperty(jg, resolver, o, path)) continue;
                this.writeScalarPropertyValue(jg, (org.nuxeo.ecm.core.schema.types.Type)((SimpleType)itemType).getPrimitiveType(), o);
            }
        } else {
            ListProperty listp = (ListProperty)prop;
            for (Property p : listp.getChildren()) {
                this.writeProperty(jg, p);
            }
        }
        jg.writeEndArray();
    }

    protected void writeComplexProperty(JsonGenerator jg, Property prop) throws IOException {
        jg.writeStartObject();
        for (Property p : prop.getChildren()) {
            if (DocumentPropertyJsonWriter.skipProperty(this.ctx, p)) continue;
            jg.writeFieldName(p.getName());
            this.writeProperty(jg, p);
        }
        jg.writeEndObject();
    }

    protected void writeBlobProperty(JsonGenerator jg, BlobProperty prop) throws IOException {
        Blob blob = (Blob)prop.getValue();
        if (blob == null) {
            jg.writeNull();
            return;
        }
        jg.writeStartObject();
        String v = blob.getFilename();
        if (v == null) {
            jg.writeNullField("name");
        } else {
            jg.writeStringField("name", v);
        }
        v = blob.getMimeType();
        if (v == null) {
            jg.writeNullField("mime-type");
        } else {
            jg.writeStringField("mime-type", v);
        }
        v = blob.getEncoding();
        if (v == null) {
            jg.writeNullField("encoding");
        } else {
            jg.writeStringField("encoding", v);
        }
        v = blob.getDigestAlgorithm();
        if (v == null) {
            jg.writeNullField("digestAlgorithm");
        } else {
            jg.writeStringField("digestAlgorithm", v);
        }
        v = blob.getDigest();
        if (v == null) {
            jg.writeNullField("digest");
        } else {
            jg.writeStringField("digest", v);
        }
        jg.writeStringField("length", Long.toString(blob.getLength()));
        String blobUrl = this.getBlobUrl((Property)prop);
        jg.writeStringField("data", blobUrl);
        this.enrichBlobProperty(jg, prop);
        jg.writeEndObject();
    }

    private void enrichBlobProperty(JsonGenerator jg, BlobProperty property) throws IOException {
        Set<String> enrichers = this.ctx.getEnrichers("blob");
        if (!enrichers.isEmpty()) {
            WrappedContext wrappedCtx = this.ctx.wrap();
            OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
            Enriched<BlobProperty> enriched = new Enriched<BlobProperty>(property);
            ParameterizedType genericType = TypeUtils.parameterize(Enriched.class, (Type[])new Type[]{BlobProperty.class});
            for (String enricherName : enrichers) {
                Closeable ignored = wrappedCtx.with("_EntityEnricherName", enricherName).open();
                Throwable throwable = null;
                try {
                    Collection<Writer<Enriched>> writers = this.registry.getAllWriters(this.ctx, Enriched.class, genericType, MediaType.APPLICATION_JSON_TYPE);
                    for (Writer<Enriched> writer : writers) {
                        writer.write(enriched, Enriched.class, genericType, MediaType.APPLICATION_JSON_TYPE, out);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
        }
    }

    private String getBlobUrl(Property prop) {
        DocumentModel doc = (DocumentModel)this.ctx.getParameter("document");
        if (doc == null) {
            return "";
        }
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String xpath = prop.getXPath();
        if (!xpath.contains(":")) {
            xpath = prop.getSchema().getName() + ":" + xpath;
        }
        Blob blob = (Blob)prop.getValue();
        return downloadService.getFullDownloadUrl(doc, xpath, blob, this.ctx.getBaseUrl());
    }

    protected static boolean skipProperty(RenderingContext ctx, Property property) {
        return ctx.getBooleanParameter(OMIT_PHANTOM_SECURED_PROPERTY) && property.isSecured() && property.isPhantom();
    }
}

