/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandTesterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.EnvironmentDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters.CommandTestResult;
import org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters.CommandTester;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.ShellExecutor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CommandLineExecutorComponent
extends DefaultComponent
implements CommandLineExecutorService {
    public static final String EP_ENV = "environment";
    public static final String EP_CMD = "command";
    public static final String EP_CMDTESTER = "commandTester";
    public static final String DEFAULT_TESTER = "DefaultCommandTester";
    public static final String DEFAULT_EXECUTOR = "ShellExecutor";
    protected static Map<String, CommandLineDescriptor> commandDescriptors = new HashMap<String, CommandLineDescriptor>();
    protected static EnvironmentDescriptor env = new EnvironmentDescriptor();
    protected static Map<String, EnvironmentDescriptor> envDescriptors = new HashMap<String, EnvironmentDescriptor>();
    protected static Map<String, CommandTester> testers = new HashMap<String, CommandTester>();
    protected static Map<String, Executor> executors = new HashMap<String, Executor>();
    private static final Log log = LogFactory.getLog(CommandLineExecutorComponent.class);

    public void activate(ComponentContext context) {
        commandDescriptors = new HashMap<String, CommandLineDescriptor>();
        env = new EnvironmentDescriptor();
        testers = new HashMap<String, CommandTester>();
        executors = new HashMap<String, Executor>();
        executors.put(DEFAULT_EXECUTOR, new ShellExecutor());
    }

    public void deactivate(ComponentContext context) {
        commandDescriptors = null;
        env = null;
        testers = null;
        executors = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_ENV.equals(extensionPoint)) {
            EnvironmentDescriptor desc = (EnvironmentDescriptor)contribution;
            String name = desc.getName();
            if (name == null) {
                env.merge(desc);
            } else {
                for (String envName : name.split(",")) {
                    if (envDescriptors.containsKey(envName)) {
                        envDescriptors.get(envName).merge(desc);
                        continue;
                    }
                    envDescriptors.put(envName, desc);
                }
            }
        } else if (EP_CMD.equals(extensionPoint)) {
            CommandLineDescriptor desc = (CommandLineDescriptor)contribution;
            String name = desc.getName();
            log.debug((Object)("Registering command: " + name));
            if (!desc.isEnabled()) {
                commandDescriptors.remove(name);
                log.info((Object)("Command configured to not be enabled: " + name));
                return;
            }
            String testerName = desc.getTester();
            if (testerName == null) {
                testerName = DEFAULT_TESTER;
                log.debug((Object)("Using default tester for command: " + name));
            }
            CommandTester tester = testers.get(testerName);
            boolean cmdAvailable = false;
            if (tester == null) {
                log.error((Object)("Unable to find tester '" + testerName + "', command will not be available: " + name));
            } else {
                log.debug((Object)("Using tester '" + testerName + "' for command: " + name));
                CommandTestResult testResult = tester.test(desc);
                cmdAvailable = testResult.succeed();
                if (cmdAvailable) {
                    log.info((Object)("Registered command: " + name));
                } else {
                    desc.setInstallErrorMessage(testResult.getErrorMessage());
                    log.warn((Object)("Command not available: " + name + " (" + desc.getInstallErrorMessage() + ". " + desc.getInstallationDirective() + ')'));
                }
            }
            desc.setAvailable(cmdAvailable);
            commandDescriptors.put(name, desc);
        } else if (EP_CMDTESTER.equals(extensionPoint)) {
            CommandTester tester;
            CommandTesterDescriptor desc = (CommandTesterDescriptor)contribution;
            try {
                tester = (CommandTester)desc.getTesterClass().newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            testers.put(desc.getName(), tester);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public ExecResult execCommand(String commandName, CmdParameters params) throws CommandNotAvailable {
        CommandAvailability availability = this.getCommandAvailability(commandName);
        if (!availability.isAvailable()) {
            throw new CommandNotAvailable(availability);
        }
        CommandLineDescriptor cmdDesc = commandDescriptors.get(commandName);
        Executor executor = executors.get(cmdDesc.getExecutor());
        EnvironmentDescriptor environment = new EnvironmentDescriptor().merge(env).merge(envDescriptors.getOrDefault(commandName, envDescriptors.get(cmdDesc.getCommand())));
        return executor.exec(cmdDesc, params, environment);
    }

    @Override
    public CommandAvailability getCommandAvailability(String commandName) {
        if (!commandDescriptors.containsKey(commandName)) {
            return new CommandAvailability(commandName + " is not a registered command");
        }
        CommandLineDescriptor desc = commandDescriptors.get(commandName);
        if (desc.isAvailable()) {
            return new CommandAvailability();
        }
        return new CommandAvailability(desc.getInstallationDirective(), desc.getInstallErrorMessage());
    }

    @Override
    public List<String> getRegistredCommands() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.addAll(commandDescriptors.keySet());
        return cmds;
    }

    @Override
    public List<String> getAvailableCommands() {
        ArrayList<String> cmds = new ArrayList<String>();
        for (String cmdName : commandDescriptors.keySet()) {
            CommandLineDescriptor cmd = commandDescriptors.get(cmdName);
            if (!cmd.isAvailable()) continue;
            cmds.add(cmdName);
        }
        return cmds;
    }

    public static CommandLineDescriptor getCommandDescriptor(String commandName) {
        return commandDescriptors.get(commandName);
    }

    @Override
    public CmdParameters getDefaultCmdParameters() {
        CmdParameters params = new CmdParameters();
        params.addNamedParameter("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        params.addNamedParameter("nuxeo.tmp.dir", Environment.getDefault().getTemp().getPath());
        return params;
    }
}

