/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.local.LocalSession;
import org.nuxeo.runtime.model.DefaultComponent;

public class CoreSessionServiceImpl
extends DefaultComponent
implements CoreSessionService {
    private static final Logger log = LogManager.getLogger(CoreSessionServiceImpl.class);
    private final Map<String, CoreSessionService.CoreSessionRegistrationInfo> sessions = new ConcurrentHashMap<String, CoreSessionService.CoreSessionRegistrationInfo>();
    protected final Cache<String, CoreSessionService.CoreSessionRegistrationInfo> recentlyClosedSessions = CacheBuilder.newBuilder().maximumSize(100L).build();

    public CloseableCoreSession createCoreSession(String repositoryName, NuxeoPrincipal principal) {
        LocalSession session = new LocalSession(repositoryName, principal);
        this.sessions.put(session.getSessionId(), new CoreSessionService.CoreSessionRegistrationInfo((CloseableCoreSession)session));
        return session;
    }

    public void releaseCoreSession(CloseableCoreSession session) {
        String sessionId = session.getSessionId();
        CoreSessionService.CoreSessionRegistrationInfo info = this.sessions.remove(sessionId);
        String debug = "closing stacktrace, sessionId=" + sessionId + ", thread=" + Thread.currentThread().getName();
        if (info == null) {
            CoreSessionService.CoreSessionRegistrationInfo closed = (CoreSessionService.CoreSessionRegistrationInfo)this.recentlyClosedSessions.getIfPresent((Object)sessionId);
            if (closed == null) {
                Exception e = new Exception("DEBUG: " + debug);
                log.warn("Closing unknown CoreSession", (Throwable)e);
            } else {
                Exception e = new Exception("DEBUG: spurious " + debug);
                e.addSuppressed((Throwable)closed);
                log.warn("Closing already closed CoreSession", (Throwable)e);
            }
        } else {
            info.addSuppressed((Throwable)new Exception("DEBUG: " + debug));
            this.recentlyClosedSessions.put((Object)sessionId, (Object)info);
            info.session = null;
        }
        session.destroy();
    }

    public CoreSession getCoreSession(String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("null sessionId");
        }
        CoreSessionService.CoreSessionRegistrationInfo info = this.sessions.get(sessionId);
        return info == null ? null : info.getCoreSession();
    }

    public int getNumberOfOpenCoreSessions() {
        return this.sessions.size();
    }

    public List<CoreSessionService.CoreSessionRegistrationInfo> getCoreSessionRegistrationInfos() {
        return new ArrayList<CoreSessionService.CoreSessionRegistrationInfo>(this.sessions.values());
    }
}

