/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.extensions;

import java.util.ArrayList;
import java.util.Collection;
import org.nuxeo.ecm.core.lifecycle.LifeCycleTransition;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleTransitionImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LifeCycleTransitionConfiguration {
    private static final String TAG_LIFECYCLE = "lifecycle";
    private static final String TAG_TRANSITIONS = "transitions";
    private static final String TAG_TRANSITION = "transition";
    private static final String ATTR_TRANSITION_NAME = "name";
    private static final String TAG_TRANSITION_DESCRIPTION = "description";
    private static final String ATTR_TRANSITION_DESTINATION_STATE = "destinationState";
    private final Element element;

    public LifeCycleTransitionConfiguration(Element element) {
        this.element = element;
    }

    public Collection<LifeCycleTransition> getTransitions() {
        ArrayList<LifeCycleTransition> transitions = new ArrayList<LifeCycleTransition>();
        NodeList transitionsElements = this.element.getElementsByTagName(TAG_TRANSITIONS);
        if (transitionsElements.getLength() <= 0) {
            return transitions;
        }
        Element transitionsElement = null;
        for (int i = 0; i < transitionsElements.getLength() && !TAG_LIFECYCLE.equals((transitionsElement = (Element)transitionsElements.item(i)).getParentNode().getNodeName()); ++i) {
        }
        NodeList elements = transitionsElement.getElementsByTagName(TAG_TRANSITION);
        int len = elements.getLength();
        for (int i = 0; i < len; ++i) {
            Element element = (Element)elements.item(i);
            String name = element.getAttribute(ATTR_TRANSITION_NAME);
            String destinationState = element.getAttribute(ATTR_TRANSITION_DESTINATION_STATE);
            String description = "";
            if (element.getElementsByTagName(TAG_TRANSITION_DESCRIPTION).getLength() > 0) {
                description = element.getElementsByTagName(TAG_TRANSITION_DESCRIPTION).item(0).getTextContent();
            }
            transitions.add(new LifeCycleTransitionImpl(name, description, destinationState));
        }
        return transitions;
    }
}

