/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.trash.AbstractTrashService;
import org.nuxeo.ecm.core.trash.TrashService;

public class BridgeTrashService
extends AbstractTrashService {
    protected final TrashService first;
    protected final TrashService second;

    public BridgeTrashService(TrashService first, TrashService second) {
        this.first = first;
        this.second = second;
    }

    public boolean isTrashed(CoreSession session, DocumentRef doc) {
        return this.first.isTrashed(session, doc) || this.second.isTrashed(session, doc);
    }

    public void trashDocuments(List<DocumentModel> docs) {
        this.second.trashDocuments(docs);
    }

    @Override
    public Set<DocumentRef> undeleteDocuments(List<DocumentModel> docs) {
        HashSet<DocumentRef> refs = new HashSet<DocumentRef>();
        refs.addAll(this.second.undeleteDocuments(docs));
        refs.addAll(this.first.undeleteDocuments(docs));
        return refs;
    }

    public boolean hasFeature(TrashService.Feature feature) {
        switch (feature) {
            case TRASHED_STATE_IN_MIGRATION: {
                return true;
            }
            case TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE: 
            case TRASHED_STATE_IS_DEDICATED_PROPERTY: {
                return false;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }
}

