/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.avro;

import java.lang.reflect.Constructor;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.nuxeo.lib.stream.codec.AvroSchemaStore;
import org.nuxeo.lib.stream.codec.FileAvroSchemaStore;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.avro.AvroMapper;
import org.nuxeo.runtime.avro.AvroReplacementDescriptor;
import org.nuxeo.runtime.avro.AvroSchemaFactory;
import org.nuxeo.runtime.avro.AvroSchemaFactoryContext;
import org.nuxeo.runtime.avro.AvroService;

public class AvroServiceImpl
implements AvroService {
    private static final AvroMapper<Object, Object> NULL = new AvroMapper<Object, Object>(null){

        @Override
        public Object fromAvro(Schema schema, Object input) {
            return null;
        }

        @Override
        public GenericRecord toAvro(Schema schema, Object input) {
            return null;
        }
    };
    protected final Map<Class<?>, Class<AvroSchemaFactory<?>>> factories;
    protected final List<AvroReplacementDescriptor> replacements;
    protected final AvroSchemaStore schemaStore;
    protected Map<Class<?>, AvroMapper<?, ?>> mappers;

    public AvroServiceImpl(Collection<AvroReplacementDescriptor> replacements, Map<Class<?>, Class<AvroSchemaFactory<?>>> factories) {
        this.replacements = new ArrayList<AvroReplacementDescriptor>(replacements);
        this.factories = new HashMap(factories);
        String dataDir = Framework.getProperty((String)"nuxeo.data.dir");
        this.schemaStore = dataDir != null ? new FileAvroSchemaStore(Paths.get(dataDir, "avro")) : new FileAvroSchemaStore(Paths.get(Framework.getRuntime().getHome().getAbsolutePath(), "data", "avro"));
        Collections.sort(this.replacements);
        this.createContext();
    }

    @Override
    public AvroSchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    @Override
    public <D> Schema createSchema(D input) {
        return this.createContext().createSchema(input);
    }

    @Override
    public String decodeName(String input) {
        String output = input;
        ListIterator<AvroReplacementDescriptor> it = this.replacements.listIterator(this.replacements.size());
        while (it.hasPrevious()) {
            AvroReplacementDescriptor descriptor = it.previous();
            output = output.replaceAll(descriptor.replacement, descriptor.forbidden);
        }
        return output;
    }

    @Override
    public String encodeName(String input) {
        String output = input;
        for (AvroReplacementDescriptor descriptor : this.replacements) {
            output = output.replaceAll(descriptor.forbidden, descriptor.replacement);
        }
        return output;
    }

    @Override
    public <D, M> D fromAvro(Schema schema, Class<D> clazz, M input) {
        return (D)this.getMapper(clazz).fromAvro(schema, input);
    }

    public void setMappers(Map<Class<?>, AvroMapper<?, ?>> mappers) {
        this.mappers = new HashMap(mappers);
    }

    @Override
    public <D, M> M toAvro(Schema schema, D input) {
        return this.getMapper(input.getClass()).toAvro(schema, input);
    }

    protected AvroSchemaFactoryContext createContext() {
        AvroSchemaFactoryContext context = new AvroSchemaFactoryContext(this);
        for (Map.Entry<Class<?>, Class<AvroSchemaFactory<?>>> entry : this.factories.entrySet()) {
            try {
                Class<AvroSchemaFactory<?>> clazz = entry.getValue();
                Constructor<AvroSchemaFactory<?>> constructor = clazz.getConstructor(AvroSchemaFactoryContext.class);
                AvroSchemaFactory<?> factory = constructor.newInstance(context);
                context.register(entry.getKey(), factory);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeServiceException((Throwable)e);
            }
        }
        return context;
    }

    protected <D, M> AvroMapper<D, M> getMapper(Class<D> clazz) {
        AvroMapper<?, ?> factory = this.mappers.get(clazz);
        if (factory != null) {
            return factory;
        }
        for (Class<?> intrface : clazz.getInterfaces()) {
            factory = this.mappers.get(intrface);
            if (factory == null) continue;
            return factory;
        }
        for (Map.Entry entry : this.mappers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
            return (AvroMapper)entry.getValue();
        }
        return NULL;
    }
}

