/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki;

public class Toc {
    protected final Entry head;
    protected Entry tail;

    public Toc() {
        this.tail = this.head = new Entry();
        this.head.title = "Table of Contents";
        this.head.id = null;
    }

    public String addHeading(String title, int level) {
        Entry entry = new Entry();
        entry.title = title;
        entry.level = level;
        if (level == this.tail.level) {
            this.tail.next = entry;
            entry.parent = this.tail.parent;
            entry.index = this.tail.index + 1;
        } else if (level > this.tail.level) {
            entry.parent = this.tail;
            this.tail.firstChild = entry;
            entry.index = 1;
        } else {
            Entry prev = this.tail.parent;
            while (prev.level > level) {
                prev = prev.parent;
            }
            if (prev.parent == null) {
                throw new IllegalStateException("Invalid headers. Header levels underflowed");
            }
            prev.next = entry;
            entry.parent = prev.parent;
            entry.index = prev.index + 1;
        }
        entry.id = entry.parent.id != null ? entry.parent.id + "." + entry.index : "" + entry.index;
        this.tail = entry;
        return entry.id;
    }

    public static class Entry {
        public Entry parent;
        public Entry next;
        public Entry firstChild;
        public String id;
        public String title;
        public int level;
        public int index;
    }
}

