/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineConverter;
import org.nuxeo.runtime.api.Framework;

public class LibreOfficeConverter
extends CommandLineConverter {
    public static final String USER_INSTALLATION_PATH_KEY = "userInstallation";
    private static final Logger log = LogManager.getLogger(LibreOfficeConverter.class);

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        Map cmdStringParameters = super.getCmdStringParameters(blobHolder, parameters);
        try {
            Path tempDirectoryPath = Framework.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
            cmdStringParameters.put(USER_INSTALLATION_PATH_KEY, tempDirectoryPath.toUri().toString());
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
        return cmdStringParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) {
        try {
            BlobHolder blobHolder = super.buildResult(cmdOutput, cmdParams);
            return blobHolder;
        }
        finally {
            String userInstallationPath = cmdParams.getParameter(USER_INSTALLATION_PATH_KEY);
            if (userInstallationPath != null) {
                this.deleteTempDirectory(userInstallationPath);
            }
        }
    }

    private void deleteTempDirectory(String tempFileURI) {
        try {
            URI uri = new URI(tempFileURI);
            File file = new File(uri);
            if (!Files.exists(file.toPath(), new LinkOption[0])) {
                return;
            }
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException | URISyntaxException e) {
            log.error((Object)e);
            log.debug((Object)e, (Throwable)e);
        }
    }
}

