/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class Encoding {
    public static final Encoding UTF8;
    public static final Encoding UTF16;
    public static final Encoding UTF16LE;
    public static final Encoding UTF16BE;
    public static final Encoding WINDOWS1252;
    private static String[] SHOULD_NOT;
    private static String[] BANNED;
    private static String[] NOT_OBSCURE;
    private static Map<String, Encoding> encodingByLowerCaseName;
    private final String canonName;
    private final Charset charset;
    private final boolean asciiSuperset;
    private final boolean obscure;
    private final boolean shouldNot;
    private final boolean likelyEbcdic;
    private Encoding actualHtmlEncoding = null;

    private static boolean isAsciiSupersetnessSensitive(int c) {
        return c >= 9 && c <= 13 || c >= 32 && c <= 34 || c >= 38 && c <= 39 || c >= 44 && c <= 63 || c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private static boolean isObscure(String lowerCasePreferredIanaName) {
        return Arrays.binarySearch(NOT_OBSCURE, lowerCasePreferredIanaName) <= -1;
    }

    private static boolean isBanned(String lowerCasePreferredIanaName) {
        return Arrays.binarySearch(BANNED, lowerCasePreferredIanaName) > -1;
    }

    private static boolean isShouldNot(String lowerCasePreferredIanaName) {
        return Arrays.binarySearch(SHOULD_NOT, lowerCasePreferredIanaName) > -1;
    }

    private static boolean asciiMapsToBasicLatin(byte[] testBuf, Charset cs) {
        CharsetDecoder dec = cs.newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPORT);
        dec.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader r = new InputStreamReader((InputStream)new ByteArrayInputStream(testBuf), dec);
        try {
            for (int i = 0; i < 127; ++i) {
                if (!(Encoding.isAsciiSupersetnessSensitive(i) ? ((Reader)r).read() != i : ((Reader)r).read() != 32)) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isLikelyEbcdic(String canonName, boolean asciiSuperset) {
        if (!asciiSuperset) {
            return canonName.startsWith("cp") || canonName.startsWith("ibm") || canonName.startsWith("x-ibm");
        }
        return false;
    }

    public static Encoding forName(String name) {
        Encoding rv = encodingByLowerCaseName.get(Encoding.toAsciiLowerCase(name));
        if (rv == null) {
            throw new UnsupportedCharsetException(name);
        }
        return rv;
    }

    public static String toAsciiLowerCase(String str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    private Encoding(String canonName, Charset charset, boolean asciiSuperset, boolean obscure, boolean shouldNot, boolean likelyEbcdic) {
        this.canonName = canonName;
        this.charset = charset;
        this.asciiSuperset = asciiSuperset;
        this.obscure = obscure;
        this.shouldNot = shouldNot;
        this.likelyEbcdic = likelyEbcdic;
    }

    public boolean isAsciiSuperset() {
        return this.asciiSuperset;
    }

    public String getCanonName() {
        return this.canonName;
    }

    public boolean isLikelyEbcdic() {
        return this.likelyEbcdic;
    }

    public boolean isObscure() {
        return this.obscure;
    }

    public boolean isShouldNot() {
        return this.shouldNot;
    }

    public boolean isRegistered() {
        return !this.canonName.startsWith("x-");
    }

    public boolean canEncode() {
        return this.charset.canEncode();
    }

    public CharsetDecoder newDecoder() {
        return this.charset.newDecoder();
    }

    public CharsetEncoder newEncoder() {
        return this.charset.newEncoder();
    }

    public Encoding getActualHtmlEncoding() {
        return this.actualHtmlEncoding;
    }

    public static void main(String[] args) {
        for (Map.Entry<String, Encoding> entry : encodingByLowerCaseName.entrySet()) {
            String name = entry.getKey();
            Encoding enc = entry.getValue();
            System.out.printf("%21s: canon %21s, obs %5s, reg %5s, asc %5s, ebc %5s\n", name, enc.getCanonName(), enc.isObscure(), enc.isRegistered(), enc.isAsciiSuperset(), enc.isLikelyEbcdic());
        }
    }

    static {
        SHOULD_NOT = new String[]{"jis_x0212-1990", "utf-32", "utf-32be", "utf-32le", "x-jis0208"};
        BANNED = new String[]{"bocu-1", "cesu-8", "compound_text", "macarabic", "maccentraleurroman", "maccroatian", "maccyrillic", "macdevanagari", "macfarsi", "macgreek", "macgujarati", "macgurmukhi", "machebrew", "macicelandic", "macroman", "macromanian", "macthai", "macturkish", "macukranian", "scsu", "utf-7", "x-imap-mailbox-name", "x-jisautodetect", "x-utf-16be-bom", "x-utf-16le-bom", "x-utf-32be-bom", "x-utf-32le-bom", "x-utf16_oppositeendian", "x-utf16_platformendian", "x-utf32_oppositeendian", "x-utf32_platformendian"};
        NOT_OBSCURE = new String[]{"big5", "big5-hkscs", "euc-jp", "euc-kr", "gb18030", "gbk", "iso-2022-jp", "iso-2022-kr", "iso-8859-1", "iso-8859-13", "iso-8859-15", "iso-8859-2", "iso-8859-3", "iso-8859-4", "iso-8859-5", "iso-8859-6", "iso-8859-7", "iso-8859-8", "iso-8859-9", "koi8-r", "shift_jis", "tis-620", "us-ascii", "utf-16", "utf-16be", "utf-16le", "utf-8", "windows-1250", "windows-1251", "windows-1252", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258"};
        encodingByLowerCaseName = new HashMap<String, Encoding>();
        byte[] testBuf = new byte[127];
        for (int i = 0; i < 127; ++i) {
            testBuf[i] = Encoding.isAsciiSupersetnessSensitive(i) ? (int)i : 32;
        }
        HashSet<Encoding> encodings = new HashSet<Encoding>();
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        for (Map.Entry<String, Charset> entry : charsets.entrySet()) {
            Charset cs = entry.getValue();
            String name = Encoding.toAsciiLowerCase(cs.name());
            if (Encoding.isBanned(name)) continue;
            name = name.intern();
            boolean asciiSuperset = Encoding.asciiMapsToBasicLatin(testBuf, cs);
            Encoding enc = new Encoding(name, cs, asciiSuperset, Encoding.isObscure(name), Encoding.isShouldNot(name), Encoding.isLikelyEbcdic(name, asciiSuperset));
            encodings.add(enc);
            Set<String> aliases = cs.aliases();
            for (String alias : aliases) {
                encodingByLowerCaseName.put(Encoding.toAsciiLowerCase(alias).intern(), enc);
            }
        }
        for (Encoding encoding : encodings) {
            encodingByLowerCaseName.put(encoding.getCanonName(), encoding);
        }
        UTF8 = Encoding.forName("utf-8");
        UTF16 = Encoding.forName("utf-16");
        UTF16BE = Encoding.forName("utf-16be");
        UTF16LE = Encoding.forName("utf-16le");
        WINDOWS1252 = Encoding.forName("windows-1252");
        try {
            Encoding.forName((String)"iso-8859-1").actualHtmlEncoding = Encoding.forName("windows-1252");
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        try {
            Encoding.forName((String)"iso-8859-11").actualHtmlEncoding = Encoding.forName("windows-874");
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        try {
            Encoding.forName((String)"x-iso-8859-11").actualHtmlEncoding = Encoding.forName("windows-874");
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        try {
            Encoding.forName((String)"tis-620").actualHtmlEncoding = Encoding.forName("windows-874");
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        try {
            Encoding.forName((String)"gb_2312-80").actualHtmlEncoding = Encoding.forName("gbk");
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        try {
            Encoding.forName((String)"gb2312").actualHtmlEncoding = Encoding.forName("gbk");
        }
        catch (UnsupportedCharsetException e) {
            // empty catch block
        }
        try {
            encodingByLowerCaseName.put("x-x-big5", Encoding.forName("big5"));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
    }
}

