/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypes {
    private static final Logger logger = Logger.getLogger(ContentTypes.class.getName());
    public static final Set<String> ALLOWED_JSON_CONTENT_TYPES = ImmutableSet.of((Object)"application/json", (Object)"text/x-json", (Object)"application/javascript", (Object)"application/x-javascript", (Object)"text/javascript", (Object)"text/ecmascript", (Object[])new String[]{"application/json-rpc", "application/jsonrequest"});
    public static final Set<String> ALLOWED_XML_CONTENT_TYPES = ImmutableSet.of((Object)"text/xml", (Object)"application/xml");
    public static final Set<String> ALLOWED_ATOM_CONTENT_TYPES = ImmutableSet.of((Object)"application/atom+xml");
    public static final Set<String> FORBIDDEN_CONTENT_TYPES = ImmutableSet.of((Object)"application/x-www-form-urlencoded");
    public static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    public static final Set<String> ALLOWED_MULTIPART_CONTENT_TYPES = ImmutableSet.of((Object)"multipart/form-data");
    public static final String OUTPUT_JSON_CONTENT_TYPE = "application/json";
    public static final String OUTPUT_XML_CONTENT_TYPE = "application/xml";
    public static final String OUTPUT_ATOM_CONTENT_TYPE = "application/atom+xml";

    public static String extractMimePart(String contentType) {
        int separator = (contentType = contentType.trim()).indexOf(59);
        if (separator != -1) {
            contentType = contentType.substring(0, separator);
        }
        return contentType.trim().toLowerCase();
    }

    public static void checkContentTypes(Set<String> allowedContentTypes, String contentType, boolean disallowUnknownContentTypes) throws InvalidContentTypeException {
        if (StringUtils.isEmpty((String)contentType)) {
            if (disallowUnknownContentTypes) {
                throw new InvalidContentTypeException("No Content-Type specified. One of " + StringUtils.join(allowedContentTypes, (String)", ") + " is required");
            }
            return;
        }
        if (FORBIDDEN_CONTENT_TYPES.contains(contentType = ContentTypes.extractMimePart(contentType))) {
            throw new InvalidContentTypeException("Cannot use disallowed Content-Type " + contentType);
        }
        if (allowedContentTypes.contains(contentType)) {
            return;
        }
        if (disallowUnknownContentTypes) {
            throw new InvalidContentTypeException("Unsupported Content-Type " + contentType + ". One of " + StringUtils.join(allowedContentTypes, (String)", ") + " is required");
        }
        logger.warning("Unsupported Content-Type " + contentType + ". One of " + StringUtils.join(allowedContentTypes, (String)", ") + " is expected");
    }

    public static class InvalidContentTypeException
    extends Exception {
        public InvalidContentTypeException(String message) {
            super(message);
        }
    }
}

