/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.helper;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

public class ProxyHelper {
    private static final Log log = LogFactory.getLog(ProxyHelper.class);

    protected ProxyHelper() {
    }

    public static void fillProxy(HttpClient httpClient, String requestUri) {
        if (ProxyHelper.useProxy(requestUri)) {
            log.info((Object)String.format("Configuring proxy for request: %s", requestUri));
            String proxyHost = ProxyHelper.getProxyHost();
            int proxyPort = ProxyHelper.getProxyPort();
            log.debug((Object)String.format("Using proxy: %s:%d", proxyHost, proxyPort));
            httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
            if (ProxyHelper.useAuthenticated()) {
                log.debug((Object)String.format("Using credentials: %s:%s", ProxyHelper.getProxyLogin(), ProxyHelper.getProxyPassword()));
                httpClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort, null), (Credentials)new UsernamePasswordCredentials(ProxyHelper.getProxyLogin(), ProxyHelper.getProxyPassword()));
            }
        }
    }

    protected static boolean useAuthenticated() {
        return !StringUtils.isEmpty((String)ProxyHelper.getProxyLogin());
    }

    protected static boolean useProxy(String requestUri) {
        Boolean useProxy = !StringUtils.isBlank((String)ProxyHelper.getProxyHost());
        useProxy = useProxy & !requestUri.contains(Framework.getProperty((String)"nuxeo.loopback.url"));
        useProxy = useProxy & !requestUri.contains(Framework.getProperty((String)"opensocial.gadgets.host"));
        return useProxy;
    }

    protected static int getProxyPort() {
        return Integer.parseInt(Framework.getProperty((String)"nuxeo.http.proxy.port"));
    }

    protected static String getProxyHost() {
        return Framework.getProperty((String)"nuxeo.http.proxy.host");
    }

    protected static String getProxyPassword() {
        return Framework.getProperty((String)"nuxeo.http.proxy.password");
    }

    protected static String getProxyLogin() {
        return Framework.getProperty((String)"nuxeo.http.proxy.login");
    }
}

