/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.op.ImplementationFactory;
import it.tidalwave.image.op.Operation;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationImplementation<O extends Operation, M> {
    private static final String CLASS = OperationImplementation.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private O operation;
    private ImplementationFactory factory;

    public void setFactory(ImplementationFactory factory) {
        this.factory = factory;
    }

    public ImplementationFactory getFactory() {
        return this.factory;
    }

    public Object execute(Object model) {
        long now = System.currentTimeMillis();
        logger.fine("executing " + this.operation);
        model = this.execute(this.operation, model);
        logger.finer(">>>> " + this.operation + " done in " + (System.currentTimeMillis() - now) + " msec");
        return model;
    }

    protected abstract M execute(O var1, M var2);

    protected void bind(O operation) {
        this.operation = operation;
    }
}

