/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.AnnotationHandlers;
import com.google.caja.ancillary.jsdoc.Comment;
import com.google.caja.ancillary.jsdoc.CommentParser;
import com.google.caja.ancillary.jsdoc.FileSystem;
import com.google.caja.ancillary.jsdoc.HtmlRenderer;
import com.google.caja.ancillary.jsdoc.Jsdoc;
import com.google.caja.ancillary.jsdoc.JsdocException;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Callback;
import com.google.caja.util.Pair;
import com.google.caja.util.RhinoExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsdocMain {
    private final MessageContext mc = new MessageContext();
    private final MessageQueue mq = new SimpleMessageQueue();
    private final FileSystem fs;
    private final AnnotationHandlers handlers = new AnnotationHandlers(this.mc);
    private final Appendable errStream;
    private final Set<String> packages = new HashSet<String>();
    private final List<String> sourcePaths = new ArrayList<String>();
    private final List<CharProducer> sourceContent = new ArrayList<CharProducer>();
    private final List<ParseTreeNode> sources = new ArrayList<ParseTreeNode>();
    private final List<Pair<String, String>> initFiles = new ArrayList<Pair<String, String>>();

    JsdocMain(FileSystem fs, Appendable errStream) {
        this.fs = fs;
        this.errStream = errStream;
    }

    public static void main(String[] argv) {
        String flag;
        int argi;
        JsdocMain jsdm = new JsdocMain(new RealFileSystem(), System.err);
        File docDir = null;
        for (argi = 0; argi < argv.length && (flag = argv[argi]).startsWith("--"); ++argi) {
            String value;
            String name;
            if ("--".equals(flag)) {
                ++argi;
                break;
            }
            int eq = flag.indexOf(61);
            if (eq >= 0) {
                name = flag.substring(2, eq);
                value = flag.substring(eq + 1);
            } else {
                name = flag.substring(2);
                value = argv[++argi];
            }
            if ("doc_dir".equals(name)) {
                docDir = new File(value);
                continue;
            }
            System.err.println("Unknown flag " + flag);
            System.exit(-1);
        }
        ArrayList<String> initPaths = new ArrayList<String>();
        ArrayList<String> sourcePaths = new ArrayList<String>();
        while (argi < argv.length) {
            if ("--init_file".equals(argv[argi])) {
                initPaths.add(argv[++argi]);
            } else {
                sourcePaths.add(argv[argi]);
            }
            ++argi;
        }
        System.exit(jsdm.run(initPaths, sourcePaths, docDir, docDir == null ? System.out : null) ? 0 : -1);
    }

    private static List<String> pathList(List<File> files) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            paths.add(file.getCanonicalPath());
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean run(List<String> initPaths, List<String> srcPaths, File docDir, Appendable out) {
        try {
            String json;
            this.addInitPaths(initPaths);
            this.classifyFiles(srcPaths);
            if (this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR)) {
                boolean bl = false;
                return bl;
            }
            this.parseInputs();
            if (this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR)) {
                boolean bl = false;
                return bl;
            }
            Jsdoc jsd = new Jsdoc(this.handlers, this.mc, this.mq);
            for (Pair<String, String> pair : this.initFiles) {
                jsd.addInitFile((String)pair.a, (String)pair.b);
            }
            for (ParseTreeNode parseTreeNode : this.sources) {
                jsd.addSource(parseTreeNode);
            }
            for (Pair pair : this.getPackageDocs()) {
                jsd.addPackage((InputSource)pair.a, (Comment)pair.b);
            }
            if (this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR)) {
                boolean i$ = false;
                return i$;
            }
            try {
                ObjectConstructor docs = jsd.extract();
                StringBuilder stringBuilder = new StringBuilder();
                this.render(docs, stringBuilder);
                json = stringBuilder.toString();
            }
            catch (JsdocException ex) {
                ex.toMessageQueue(this.mq);
                boolean bl = false;
                return bl;
            }
            if (this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR)) {
                boolean ex = false;
                return ex;
            }
            if (out != null) {
                out.append(json);
            }
            if (docDir != null) {
                HtmlRenderer.buildHtml(json, this.fs, docDir, this.sourceContent, this.mc);
            }
            boolean ex = true;
            return ex;
        }
        finally {
            this.reportMessages();
        }
    }

    private void addInitPaths(List<String> paths) {
        for (String path : paths) {
            try {
                String f = this.fs.canonicalPath(path);
                if (!this.fs.exists(f)) {
                    this.mq.addMessage((MessageTypeInt)MessageType.NO_SUCH_FILE, this.fs.toInputSource(f));
                    continue;
                }
                this.initFiles.add(Pair.pair(f, this.fs.read(f).toString()));
            }
            catch (IOException ex) {
                this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(path));
            }
        }
    }

    private void classifyFiles(List<String> paths) {
        for (String path : paths) {
            try {
                String f = this.fs.canonicalPath(path);
                if (!this.fs.exists(f)) {
                    this.mq.addMessage((MessageTypeInt)MessageType.NO_SUCH_FILE, this.fs.toInputSource(f));
                    continue;
                }
                if (this.fs.isFile(f)) {
                    this.packages.add(this.fs.dirname(f));
                    if ("package.html".equals(this.fs.basename(f))) continue;
                    this.sourcePaths.add(f);
                    continue;
                }
                if (!this.fs.isDirectory(f)) continue;
                this.packages.add(f);
            }
            catch (IOException ex) {
                this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(path));
            }
        }
    }

    private CharProducer readSource(String path) throws IOException {
        CharProducer cp = this.fs.read(path);
        this.sourceContent.add(cp);
        this.mc.addInputSource(cp.getSourceBreaks(0).source());
        return cp;
    }

    private void parseInputs() {
        for (String path : this.sourcePaths) {
            try {
                CharProducer cp = this.readSource(path);
                InputSource is = cp.getSourceBreaks(0).source();
                JsLexer lexer = new JsLexer(cp, false);
                JsTokenQueue tq = new JsTokenQueue(lexer, is);
                Parser p = new Parser(tq, this.mq);
                this.sources.add(p.parse());
            }
            catch (IOException ex) {
                this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(path));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(this.mq);
            }
        }
    }

    private List<Pair<InputSource, Comment>> getPackageDocs() {
        ArrayList<Pair<InputSource, Comment>> pkgs = new ArrayList<Pair<InputSource, Comment>>();
        for (String packagePath : this.packages) {
            try {
                String packageFile = this.fs.join(packagePath, "package.html");
                if (!this.fs.exists(packageFile)) continue;
                CharProducer cp = this.readSource(packageFile);
                try {
                    Comment cmt = CommentParser.parseStructuredComment(cp);
                    pkgs.add(Pair.pair(this.fs.toInputSource(packagePath), cmt));
                }
                catch (ParseException ex) {
                    ex.toMessageQueue(this.mq);
                }
            }
            catch (IOException ex) {
                this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, this.fs.toInputSource(packagePath));
            }
        }
        return pkgs;
    }

    private void reportMessages() {
        MessageLevel maxMessageLevel = MessageLevel.SUMMARY;
        for (Message msg : this.mq.getMessages()) {
            MessageLevel ml = msg.getMessageLevel();
            if (ml.compareTo(maxMessageLevel) <= 0) continue;
            maxMessageLevel = ml;
        }
        for (Message msg : this.mq.getMessages()) {
            if (msg.getMessageLevel() != maxMessageLevel) continue;
            try {
                this.errStream.append(msg.getMessageLevel().name()).append(' ');
                msg.format(this.mc, this.errStream);
                this.errStream.append('\n');
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void render(final ParseTreeNode node, Appendable out) {
        TokenConsumer tc = node.makeRenderer(out, new Callback<IOException>(){

            @Override
            public void handle(IOException ex) {
                JsdocMain.this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, node.getFilePosition());
            }
        });
        node.render(new RenderContext(tc));
        tc.noMoreTokens();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RestrictedFileSystem
    implements FileSystem {
        private final Set<String> files = new HashSet<String>();
        private final File outputRoot;

        private RestrictedFileSystem(Collection<String> files, File outputRoot) {
            this.files.addAll(files);
            this.outputRoot = outputRoot;
        }

        @Override
        public String basename(String path) {
            return new File(path).getName();
        }

        @Override
        public String canonicalPath(String path) throws IOException {
            String canonPath = new File(path).getCanonicalPath();
            this.allowedInputFile(canonPath);
            return canonPath;
        }

        @Override
        public String dirname(String path) {
            return new File(path).getParent();
        }

        @Override
        public boolean exists(String path) {
            return this.files.contains(path) && new File(path).exists();
        }

        @Override
        public boolean isDirectory(String path) {
            return this.files.contains(path) && new File(path).isDirectory();
        }

        @Override
        public boolean isFile(String path) {
            return this.files.contains(path) && new File(path).isFile();
        }

        @Override
        public String join(String dir, String filename) {
            return "".equals(dir) ? filename : new File(dir, filename).getPath();
        }

        @Override
        public CharProducer read(String path) throws IOException {
            File f = this.allowedInputFile(path);
            return CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"), this.toInputSource(path));
        }

        @Override
        public InputSource toInputSource(String path) {
            return new InputSource(new File(path).toURI());
        }

        @Override
        public Writer write(String path) throws IOException {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.allowedOutputFile(path)), "UTF-8");
        }

        @Override
        public OutputStream writeBytes(String path) throws IOException {
            return new FileOutputStream(this.allowedOutputFile(path));
        }

        @Override
        public void mkdir(String path) throws IOException {
            this.allowedOutputFile(path).mkdirs();
        }

        private File allowedInputFile(String path) throws IOException {
            File f;
            for (File anc = f = new File(path); anc != null; anc = anc.getParentFile()) {
                if (!this.files.contains(anc.getPath())) continue;
                return f;
            }
            throw new FileNotFoundException(path);
        }

        private File allowedOutputFile(String path) throws IOException {
            File f;
            for (File anc = f = new File(path); anc != null; anc = anc.getParentFile()) {
                if (!this.outputRoot.equals(anc)) continue;
                return f;
            }
            throw new FileNotFoundException(path);
        }
    }

    static class RealFileSystem
    implements FileSystem {
        RealFileSystem() {
        }

        public String basename(String path) {
            return new File(path).getName();
        }

        public String canonicalPath(String path) throws IOException {
            return new File(path).getCanonicalPath();
        }

        public String dirname(String path) {
            return new File(path).getParent();
        }

        public boolean exists(String path) {
            return new File(path).exists();
        }

        public boolean isDirectory(String path) {
            return new File(path).isDirectory();
        }

        public boolean isFile(String path) {
            return new File(path).isFile();
        }

        public String join(String dir, String filename) {
            return "".equals(dir) ? filename : new File(dir, filename).getPath();
        }

        public CharProducer read(String path) throws IOException {
            return CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"), this.toInputSource(path));
        }

        public InputSource toInputSource(String path) {
            return new InputSource(new File(path).toURI());
        }

        public Writer write(String path) throws IOException {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
        }

        public OutputStream writeBytes(String path) throws IOException {
            return new FileOutputStream(path);
        }

        public void mkdir(String path) {
            new File(path).mkdir();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements BuildCommand {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean build(List<File> inputs, List<File> deps, File output) throws IOException {
            ArrayList<String> initPaths = new ArrayList<String>();
            initPaths.add(Builder.resourceToPath("/js/jqueryjs/runtest/env.js"));
            initPaths.add(Builder.resourceToPath("jsdoc_init.js"));
            RhinoExecutor.enableContentUrls();
            List files = JsdocMain.pathList(inputs);
            files.addAll(initPaths);
            RestrictedFileSystem fs = new RestrictedFileSystem(files, output);
            JsdocMain jsdm = new JsdocMain(fs, System.err);
            OutputStreamWriter out = null;
            File docDir = null;
            if (output.isDirectory()) {
                docDir = output;
            } else {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8");
            }
            StringWriter buf = new StringWriter();
            if (!jsdm.run(initPaths, JsdocMain.pathList(inputs), docDir, buf)) {
                return false;
            }
            if (out != null) {
                try {
                    out.write(((Object)buf).toString());
                }
                finally {
                    ((Writer)out).close();
                }
            }
            return true;
        }

        private static String resourceToPath(String resource) throws IOException {
            try {
                return new File(Builder.class.getResource(resource).toURI()).toString();
            }
            catch (URISyntaxException ex) {
                FileNotFoundException fnf = new FileNotFoundException(resource);
                fnf.initCause(ex);
                throw fnf;
            }
        }
    }
}

