/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RuleDoclet;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class HtmlRuleDoclet
extends RuleDoclet {
    private Document htmlDocument;
    private Element body;
    private Element table;
    private int countRules;
    private static final String HTML_NS = Namespaces.HTML_NAMESPACE_URI;

    public String getDefaultExtension() {
        return "html";
    }

    public void initialize(Writer output) {
        DOMImplementation impl;
        try {
            impl = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 1.0");
            String implPropName = "org.w3c.dom.DOMImplementationSourceList";
            if (impl == null && null == System.getProperty(implPropName)) {
                System.getProperties().setProperty(implPropName, "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
                impl = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 1.0");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String qname = "html";
        String systemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
        String publicId = "-//W3C//DTD XHTML 1.0 Transitional//EN";
        this.htmlDocument = impl.createDocument(systemId, qname, impl.createDocumentType(qname, publicId, systemId));
        assert (qname.equals(this.htmlDocument.getDocumentElement().getLocalName()));
    }

    private Element headerRow(String ... cells) {
        Element thead = this.htmlDocument.createElementNS(HTML_NS, "thead");
        thead.appendChild(this.row(cells));
        return thead;
    }

    private Element row(String ... cells) {
        Element tr = this.htmlDocument.createElementNS(HTML_NS, "tr");
        for (String cell : cells) {
            Element td = this.htmlDocument.createElementNS(HTML_NS, "td");
            td.appendChild(this.htmlDocument.createTextNode(cell));
            tr.appendChild(td);
        }
        return tr;
    }

    public void generateHeader(Writer output, RulesetDescription ruleSet) {
        Element head = this.htmlDocument.createElementNS(HTML_NS, "head");
        Element title = this.htmlDocument.createElementNS(HTML_NS, "title");
        title.appendChild(this.htmlDocument.createTextNode(ruleSet.name()));
        head.appendChild(title);
        Element meta = this.htmlDocument.createElementNS(HTML_NS, "meta");
        meta.setAttributeNS(HTML_NS, "http-equiv", "Content-Type");
        meta.setAttributeNS(HTML_NS, "content", "text/html; charset=utf-8");
        head.appendChild(meta);
        Element style = this.htmlDocument.createElementNS(HTML_NS, "style");
        style.setAttributeNS(HTML_NS, "type", "text/css");
        style.appendChild(this.htmlDocument.createTextNode("h1 { text-align: center }\ndiv.centered { text-align: center }\ndiv.centered table { margin: 0 auto; text-align: left }\n"));
        head.appendChild(style);
        this.htmlDocument.getDocumentElement().appendChild(head);
        this.body = this.htmlDocument.createElementNS(HTML_NS, "body");
        Element h1 = this.htmlDocument.createElementNS(HTML_NS, "h1");
        h1.appendChild(this.htmlDocument.createTextNode(ruleSet.name()));
        this.body.appendChild(h1);
        Element h2 = this.htmlDocument.createElementNS(HTML_NS, "h2");
        h2.appendChild(this.htmlDocument.createTextNode(ruleSet.synopsis()));
        this.body.appendChild(h2);
        this.htmlDocument.getDocumentElement().appendChild(this.body);
    }

    public void generateFooter(Writer output, RulesetDescription ruleSet) {
    }

    public void finish(Writer output) {
        DOMSource src = new DOMSource(this.htmlDocument);
        StreamResult result = new StreamResult(output);
        try {
            TransformerFactory.newInstance().newTransformer().transform(src, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void generateRuleDocumentation(Writer output, RuleDescription anno) {
        if (0 == this.countRules) {
            this.table = this.htmlDocument.createElementNS(HTML_NS, "table");
            this.table.appendChild(this.headerRow("", "Rule", "Synopsis", "Reason", "Matches", "Substitutes"));
            this.body.appendChild(this.table);
        }
        this.table.appendChild(this.row("" + this.countRules++, anno.name(), anno.synopsis(), anno.reason(), anno.matches(), anno.substitutes()));
    }
}

