/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.CajaException;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameContext<NAME, BINDING> {
    private final NameContext<NAME, BINDING> parent;
    private final Iterator<String> nameGenerator;
    private final Map<NAME, VarInfo<NAME, BINDING>> vars = Maps.newLinkedHashMap();

    public NameContext(Iterator<String> nameGenerator) {
        this(null, nameGenerator);
    }

    private NameContext(NameContext<NAME, BINDING> parent, Iterator<String> nameGenerator) {
        this.parent = parent;
        this.nameGenerator = nameGenerator;
    }

    public NameContext<NAME, BINDING> makeChildContext() {
        return new NameContext<NAME, BINDING>(this, this.nameGenerator);
    }

    public NameContext<NAME, BINDING> getParentContext() {
        return this.parent;
    }

    public VarInfo<NAME, BINDING> declare(NAME origName, FilePosition declSite) throws RedeclarationException {
        VarInfo<NAME, BINDING> d = this.vars.get(origName);
        if (d == null) {
            String newName = this.nameGenerator.next();
            VarInfo vi = new VarInfo(origName, newName, declSite);
            this.vars.put(origName, vi);
            return vi;
        }
        FilePosition dPos = d.declaredAt;
        throw new RedeclarationException(new Message((MessageTypeInt)RewriterMessageType.CANNOT_REDECLARE_VAR, declSite, MessagePart.Factory.valueOf(origName.toString()), dPos));
    }

    public VarInfo<NAME, BINDING> lookup(NAME originalName) {
        NameContext<NAME, BINDING> c = this;
        while (c != null) {
            VarInfo<NAME, BINDING> vi = c.vars.get(originalName);
            if (vi != null) {
                return vi;
            }
            c = c.parent;
        }
        return null;
    }

    public Iterable<VarInfo<NAME, BINDING>> vars() {
        return Collections.unmodifiableMap(this.vars).values();
    }

    public Iterator<String> getNameGenerator() {
        return this.nameGenerator;
    }

    public static class RedeclarationException
    extends CajaException {
        public RedeclarationException(Message m, Throwable th) {
            super(m, th);
        }

        public RedeclarationException(Message m) {
            this(m, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VarInfo<NAME, BINDING> {
        public final NAME origName;
        public final String newName;
        public final FilePosition declaredAt;
        private BINDING binding;

        private VarInfo(NAME origName, String newName, FilePosition declaredAt) {
            assert (origName != null);
            this.origName = origName;
            this.newName = newName;
            this.declaredAt = declaredAt;
        }

        public BINDING getBinding() {
            return this.binding;
        }

        public void bind(BINDING binding) {
            this.binding = binding;
        }

        public String toString() {
            return "(" + this.getClass().getSimpleName() + " " + this.origName + ")";
        }
    }
}

