/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.oauth;

import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.nuxeo.ecm.platform.oauth.keys.OAuthServerKeyManager;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.shindig.oauth.NXOAuthStore;
import org.nuxeo.runtime.api.Framework;

@Singleton
public class NXOAuthStoreProvider
implements Provider<OAuthStore> {
    protected NXOAuthStore store = new NXOAuthStore();

    public NXOAuthStoreProvider() {
        OAuthServerKeyManager skm = (OAuthServerKeyManager)Framework.getLocalService(OAuthServerKeyManager.class);
        OpenSocialService os = (OpenSocialService)Framework.getLocalService(OpenSocialService.class);
        this.store.setDefaultCallbackUrl(os.getOAuthCallbackUrl());
        String privateKey = skm.getBarePrivateKey();
        String signingKeyName = skm.getKeyName();
        BasicOAuthStoreConsumerKeyAndSecret key = new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
        this.store.setDefaultKey(key);
    }

    public OAuthStore get() {
        return this.store;
    }
}

