/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class GwtBundleActivator
implements BundleActivator {
    protected static final Log log = LogFactory.getLog(GwtBundleActivator.class);
    public static final String GWT_DEV_MODE_PROP = "nuxeo.gwt_dev_mode";
    public static final File GWT_ROOT = new File(Environment.getDefault().getWeb(), "root.war/gwt");
    public static final boolean GWT_DEV_MODE = "true".equals(System.getProperty("nuxeo.gwt_dev_mode", "false"));
    protected BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (GWT_DEV_MODE) {
            return;
        }
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 1) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                try {
                    GwtBundleActivator.this.installGwtApp(GwtBundleActivator.this.context.getBundle());
                }
                catch (Exception cause) {
                    log.error((Object)"Cannot install gwt app", (Throwable)cause);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
    }

    protected void installGwtApp(Bundle bundle) throws Exception {
        GWT_ROOT.mkdirs();
        String symName = bundle.getSymbolicName();
        File markerFile = new File(GWT_ROOT, ".metadata/" + symName);
        File file = Framework.getRuntime().getBundleFile(bundle);
        if (file == null) {
            log.warn((Object)"A GWT module without a war directory inside");
            return;
        }
        if (markerFile.lastModified() < file.lastModified()) {
            log.info((Object)("Installing GWT Application from bundle " + symName));
            ZipUtils.unzip((String)"gwt-war", (File)file, (File)GWT_ROOT);
            markerFile.getParentFile().mkdirs();
            markerFile.createNewFile();
        }
    }
}

