/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.UriCallback;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.parser.html.Nodes;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.reporting.SnippetProducer;
import com.google.caja.util.Pair;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CajaContentRewriter
implements GadgetRewriter {
    public static final String CAJOLED_DOCUMENTS = "cajoledDocuments";
    private final Logger logger = Logger.getLogger(CajaContentRewriter.class.getName());
    private Cache<String, Element> cajoledCache;

    @Inject
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cajoledCache = cacheProvider.createCache(CAJOLED_DOCUMENTS);
        System.err.println("Cajoled cache created" + this.cajoledCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrite(Gadget gadget, MutableContent content) {
        if (gadget.getSpec().getModulePrefs().getFeatures().containsKey("caja") || "1".equals(gadget.getContext().getParameter("caja"))) {
            final URI retrievedUri = gadget.getContext().getUrl().toJavaUri();
            UriCallback cb = new UriCallback(){

                public Reader retrieve(ExternalReference externalReference, String string) throws UriCallbackException {
                    CajaContentRewriter.this.logger.info("Retrieving " + externalReference.toString());
                    try {
                        int n;
                        URI resourceUri = retrievedUri.resolve(externalReference.getUri());
                        InputStreamReader in = new InputStreamReader(resourceUri.toURL().openConnection().getInputStream(), "UTF-8");
                        char[] buf = new char[4096];
                        StringBuilder sb = new StringBuilder();
                        while ((n = in.read(buf)) > 0) {
                            sb.append(buf, 0, n);
                        }
                        return new StringReader(sb.toString());
                    }
                    catch (MalformedURLException ex) {
                        throw new UriCallbackException(externalReference, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        throw new UriCallbackException(externalReference, (Throwable)ex);
                    }
                }

                public URI rewrite(ExternalReference externalReference, String mimeType) {
                    URI uri = externalReference.getUri();
                    if (uri.getScheme().equalsIgnoreCase("https") || uri.getScheme().equalsIgnoreCase("http")) {
                        return retrievedUri.resolve(uri);
                    }
                    if ("javascript".equalsIgnoreCase(uri.getScheme())) {
                        return uri.toString().equals("javascript:void(0)") ? uri : null;
                    }
                    return null;
                }
            };
            String key = HashUtil.rawChecksum((byte[])content.getContent().getBytes());
            Document doc = content.getDocument();
            DocumentFragment root = doc.createDocumentFragment();
            root.appendChild(doc.getDocumentElement());
            Element cajoledOutput = null;
            if (null != this.cajoledCache && null != (cajoledOutput = (Element)this.cajoledCache.getElement((Object)key))) {
                this.createContainerFor(doc, doc.adoptNode(cajoledOutput));
                content.documentChanged();
                HtmlSerialization.attach(doc, new CajaHtmlSerializer(), null);
                return;
            }
            SimpleMessageQueue mq = new SimpleMessageQueue();
            BuildInfo bi = BuildInfo.getInstance();
            DefaultGadgetRewriter rw = new DefaultGadgetRewriter(bi, (MessageQueue)mq);
            rw.setValijaMode(true);
            InputSource is = new InputSource(retrievedUri);
            boolean safe = false;
            try {
                Pair htmlAndJs = rw.rewriteContent(retrievedUri, (Node)root, cb);
                Node html = (Node)htmlAndJs.a;
                Element script = (Element)htmlAndJs.b;
                cajoledOutput = doc.createElement("div");
                cajoledOutput.setAttribute("id", "cajoled-output");
                cajoledOutput.setAttribute("classes", "g___");
                cajoledOutput.setAttribute("style", "position: relative;");
                cajoledOutput.appendChild(doc.adoptNode(html));
                cajoledOutput.appendChild(this.tameCajaClientApi(doc));
                cajoledOutput.appendChild(doc.adoptNode(script));
                if (this.cajoledCache != null) {
                    this.cajoledCache.addElement((Object)key, (Object)cajoledOutput);
                }
                this.createContainerFor(doc, cajoledOutput);
                content.documentChanged();
                safe = true;
                HtmlSerialization.attach(doc, new CajaHtmlSerializer(), null);
            }
            catch (GadgetRewriteException e) {
                this.createContainerFor(doc, this.formatErrors(doc, is, content.getContent(), (MessageQueue)mq));
                this.logException((Exception)((Object)e), (MessageQueue)mq);
                safe = true;
            }
            finally {
                if (!safe) {
                    content.setContent("");
                }
            }
        }
    }

    private void createContainerFor(Document doc, Node el) {
        Element docEl = doc.createElement("html");
        Element head = doc.createElement("head");
        Element body = doc.createElement("body");
        doc.appendChild(docEl);
        docEl.appendChild(head);
        docEl.appendChild(body);
        body.appendChild(el);
    }

    private Element formatErrors(Document doc, InputSource is, CharSequence orig, MessageQueue mq) {
        MessageContext mc = new MessageContext();
        HashMap originalSrc = Maps.newHashMap();
        originalSrc.put(is, orig);
        mc.addInputSource(is);
        SnippetProducer sp = new SnippetProducer((Map)originalSrc, mc);
        StringBuilder messageText = new StringBuilder();
        for (Message msg : mq.getMessages()) {
            if (MessageLevel.LINT.compareTo((Enum)msg.getMessageLevel()) > 0) continue;
            String snippet = sp.getSnippet(msg);
            messageText.append(msg.getMessageLevel().name()).append(" ").append(CajaContentRewriter.html(msg.format(mc)));
            if (StringUtils.isEmpty((String)snippet)) continue;
            messageText.append("\n").append(snippet);
        }
        Element errElement = doc.createElement("pre");
        errElement.appendChild(doc.createTextNode(messageText.toString()));
        return errElement;
    }

    private static String html(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        Escaping.escapeXml((CharSequence)s, (boolean)false, (StringBuilder)sb);
        return sb.toString();
    }

    private Element tameCajaClientApi(Document doc) {
        Element scriptElement = doc.createElement("script");
        scriptElement.setAttribute("type", "text/javascript");
        scriptElement.appendChild(doc.createTextNode("caja___.enable()"));
        return scriptElement;
    }

    private void logException(Exception cause, MessageQueue mq) {
        StringBuilder errbuilder = new StringBuilder();
        MessageContext mc = new MessageContext();
        if (cause != null) {
            errbuilder.append(cause).append('\n');
        }
        for (Message m : mq.getMessages()) {
            errbuilder.append(m.format(mc)).append('\n');
        }
        this.logger.info("Unable to cajole gadget: " + errbuilder);
    }

    private static class CajaHtmlSerializer
    implements HtmlSerializer {
        private CajaHtmlSerializer() {
        }

        public String serialize(Document doc) {
            StringWriter sw = HtmlSerialization.createWriter(doc);
            return Nodes.render((Node)doc, (boolean)new RenderContext((TokenConsumer)new Concatenator((Appendable)sw, null)).asXml());
        }
    }
}

