/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.templates.ElementELResolver;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateBasedTagHandler
extends AbstractTagHandler {
    private final Element templateDefinition;

    public TemplateBasedTagHandler(Element templateDefinition, String namespaceUri, String tagName) {
        super(namespaceUri, tagName);
        this.templateDefinition = templateDefinition;
    }

    @Override
    public void process(Node result, Element tagInstance, TemplateProcessor processor) {
        DocumentFragment processedContent = this.processChildren(tagInstance, processor);
        Map<String, Object> oldMy = processor.getTemplateContext().setMy(this.computeMy(tagInstance, processedContent, processor));
        Object oldCur = processor.getTemplateContext().setCur(null);
        Node oldTemplateRoot = processor.getTemplateContext().setTemplateRoot(processedContent);
        this.processTemplate(result, tagInstance, processor);
        processor.getTemplateContext().setMy(oldMy);
        processor.getTemplateContext().setCur(oldCur);
        processor.getTemplateContext().setTemplateRoot(oldTemplateRoot);
    }

    protected void processTemplate(Node result, Element tagInstance, TemplateProcessor processor) {
        processor.processChildNodes(result, this.templateDefinition);
    }

    protected Map<String, Object> computeMy(Element tagInstance, Node processedContent, TemplateProcessor processor) {
        HashMap myMap = Maps.newHashMap();
        NodeList children = processedContent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            List bucket;
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element el = (Element)child;
            String name = el.getLocalName();
            if (name == null) {
                name = el.getNodeName();
            }
            ElementELResolver.ElementWrapper wrapper = new ElementELResolver.ElementWrapper(el);
            Object previous = myMap.get(name);
            if (previous == null) {
                myMap.put(name, wrapper);
                continue;
            }
            if (previous instanceof ElementELResolver.ElementWrapper) {
                bucket = Lists.newArrayListWithCapacity((int)children.getLength());
                bucket.add((ElementELResolver.ElementWrapper)previous);
                bucket.add(wrapper);
                myMap.put(name, bucket);
                continue;
            }
            bucket = (List)previous;
            bucket.add(wrapper);
        }
        NamedNodeMap atts = tagInstance.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.item(i).getNodeName();
            myMap.put(name, this.getValueFromTag(tagInstance, name, processor, Object.class));
        }
        return myMap;
    }
}

