/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.util.ClassUtils;

public class ResourceUtils {
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String URL_PREFIX = "url:";
    public static final String FILE_PREFIX = "file:";
    private static final Log log = LogFactory.getLog(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static boolean hasResourcePrefix(String resourcePath) {
        return resourcePath != null && (resourcePath.startsWith(CLASSPATH_PREFIX) || resourcePath.startsWith(URL_PREFIX) || resourcePath.startsWith(FILE_PREFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceExists(String resourcePath) {
        InputStream stream = null;
        boolean exists = false;
        try {
            stream = ResourceUtils.getInputStreamForPath(resourcePath);
            exists = true;
        }
        catch (IOException e) {
            stream = null;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return exists;
    }

    public static InputStream getInputStreamForPath(String resourcePath) throws IOException {
        InputStream is = resourcePath.startsWith(CLASSPATH_PREFIX) ? ResourceUtils.loadFromClassPath(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(URL_PREFIX) ? ResourceUtils.loadFromUrl(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(FILE_PREFIX) ? ResourceUtils.loadFromFile(ResourceUtils.stripPrefix(resourcePath)) : ResourceUtils.loadFromFile(resourcePath)));
        if (is == null) {
            throw new IOException("Resource [" + resourcePath + "] could not be found.");
        }
        return is;
    }

    private static InputStream loadFromFile(String path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening file [" + path + "]..."));
        }
        return new FileInputStream(path);
    }

    private static InputStream loadFromUrl(String urlPath) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening url [" + urlPath + "]..."));
        }
        URL url = new URL(urlPath);
        return url.openStream();
    }

    private static InputStream loadFromClassPath(String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening resource from class path [" + path + "]..."));
        }
        return ClassUtils.getResourceAsStream(path);
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(":") + 1);
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error closing input stream.", (Throwable)e);
            }
        }
    }
}

