/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.spring;

import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.JSecurityException;
import org.jsecurity.mgt.RealmSecurityManager;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.web.config.IniWebConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringIniWebConfiguration
extends IniWebConfiguration {
    public static final String SECURITY_MANAGER_BEAN_NAME_PARAM_NAME = "securityManagerBeanName";
    public static final String DEFAULT_SECURITY_MANAGER_BEAN_ID = "securityManager";
    private static final Log log = LogFactory.getLog(SpringIniWebConfiguration.class);
    protected String securityManagerBeanName;

    public String getSecurityManagerBeanName() {
        return this.securityManagerBeanName;
    }

    public void setSecurityManagerBeanName(String securityManagerBeanName) {
        this.securityManagerBeanName = securityManagerBeanName;
    }

    @Override
    public void init() throws JSecurityException {
        String beanName = this.getFilterConfig().getInitParameter(SECURITY_MANAGER_BEAN_NAME_PARAM_NAME);
        if (beanName != null) {
            this.setSecurityManagerBeanName(beanName);
        }
        super.init();
    }

    @Override
    protected SecurityManager createDefaultSecurityManager() {
        return this.createSecurityManager(null);
    }

    @Override
    protected SecurityManager createSecurityManager(Map<String, Map<String, String>> sections) {
        ServletContext servletContext = this.getFilterConfig().getServletContext();
        WebApplicationContext appCtx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return this.getOrCreateSecurityManager((ApplicationContext)appCtx, sections);
    }

    protected SecurityManager getOrCreateSecurityManager(ApplicationContext appCtx, Map<String, Map<String, String>> sections) {
        String beanName = this.getSecurityManagerBeanName();
        SecurityManager securityManager = null;
        if (beanName != null) {
            securityManager = (SecurityManager)appCtx.getBean(beanName, SecurityManager.class);
        }
        if (securityManager == null) {
            securityManager = this.getSecurityManagerByType(appCtx);
        }
        if (securityManager == null) {
            securityManager = this.createDefaultSecurityManagerFromRealms(appCtx, sections);
        }
        if (securityManager == null) {
            String msg = "Unable to locate a " + SecurityManager.class.getName() + " instance in the " + "Spring WebApplicationContext.  You can 1) simply just define the securityManager as a bean (" + "it will be automatically located based on type) or " + "2) explicitly specifify which bean is retrieved by setting this filter's " + "'securityManagerBeanName' init-param or 3) define one or more " + Realm.class.getName() + " instances and a default SecurityManager using those realms will be created automatically.";
            throw new ApplicationContextException(msg);
        }
        return securityManager;
    }

    protected SecurityManager createDefaultSecurityManagerFromRealms(ApplicationContext appCtx, Map<String, Map<String, String>> sections) {
        SecurityManager securityManager = null;
        Map realmMap = appCtx.getBeansOfType(Realm.class);
        if (realmMap == null || realmMap.isEmpty()) {
            return null;
        }
        Collection<Realm> realms = realmMap.values();
        if (realms == null || realms.isEmpty()) {
            return null;
        }
        if (!realms.isEmpty()) {
            securityManager = super.createSecurityManager(sections);
            if (securityManager instanceof RealmSecurityManager) {
                RealmSecurityManager realmSM = (RealmSecurityManager)securityManager;
                realmSM.setRealms(realms);
            } else {
                log.warn((Object)("Attempted to set realms declared in Spring on SecurityManager, but was not of type RealmSecurityManager - instead was of type: " + securityManager.getClass().getName()));
            }
        }
        return securityManager;
    }

    protected SecurityManager getSecurityManagerByType(ApplicationContext appCtx) {
        SecurityManager securityManager = null;
        Map securityManagers = appCtx.getBeansOfType(SecurityManager.class);
        if (securityManagers == null || securityManagers.isEmpty()) {
            return null;
        }
        if (securityManagers.size() > 1) {
            securityManager = (SecurityManager)securityManagers.get(DEFAULT_SECURITY_MANAGER_BEAN_ID);
            if (securityManager == null) {
                String msg = "There is more than one bean of type " + SecurityManager.class.getName() + " available in the " + "Spring WebApplicationContext.  Please specify which bean should be used by " + "setting this filter's 'securityManagerBeanName' init-param or by naming one of the " + "security managers '" + DEFAULT_SECURITY_MANAGER_BEAN_ID + "'.";
                throw new ApplicationContextException(msg);
            }
        } else if (securityManagers.size() == 1) {
            securityManager = (SecurityManager)securityManagers.values().iterator().next();
        }
        return securityManager;
    }
}

