/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.util.InstantiationException;
import org.jsecurity.util.UnknownClassException;

public class ClassUtils {
    private static final Log log = LogFactory.getLog(ClassUtils.class);

    public static InputStream getResourceAsStream(String name) {
        InputStream is = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            is = cl.getResourceAsStream(name);
        }
        if (is == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Resource [" + name + "] was not found via the thread context ClassLoader.  Trying the " + "current ClassLoader..."));
            }
            if ((is = (cl = ClassUtils.class.getClassLoader()).getResourceAsStream(name)) == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Resource [" + name + "] was not found via the current class loader.  Trying the " + "system/application ClassLoader..."));
                }
                if ((is = (cl = ClassLoader.getSystemClassLoader()).getResourceAsStream(name)) == null && log.isTraceEnabled()) {
                    log.trace((Object)("Resource [" + name + "] was not found via the thread context, current, or " + "system/application ClassLoaders.  All heuristics have been exhausted.  Returning null."));
                }
            }
        }
        return is;
    }

    public static Class forName(String fqcn) throws UnknownClassException {
        Class<?> clazz;
        block11: {
            ClassLoader cl;
            block10: {
                clazz = null;
                cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    try {
                        clazz = cl.loadClass(fqcn);
                    }
                    catch (ClassNotFoundException e) {
                        if (!log.isTraceEnabled()) break block10;
                        log.trace((Object)("Unable to load class named [" + fqcn + "] from the thread context ClassLoader.  Trying the current ClassLoader..."));
                    }
                }
            }
            if (clazz == null) {
                cl = ClassUtils.class.getClassLoader();
                try {
                    clazz = cl.loadClass(fqcn);
                }
                catch (ClassNotFoundException e1) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Unable to load class named [" + fqcn + "] from the current ClassLoader.  " + "Trying the system/application ClassLoader..."));
                    }
                    cl = ClassLoader.getSystemClassLoader();
                    try {
                        clazz = cl.loadClass(fqcn);
                    }
                    catch (ClassNotFoundException ignored) {
                        if (!log.isTraceEnabled()) break block11;
                        log.trace((Object)("Unable to load class named [" + fqcn + "] from the " + "system/application ClassLoader."));
                    }
                }
            }
        }
        if (clazz == null) {
            String msg = "Unable to load class named [" + fqcn + "] from the thread context, current, or " + "system/application ClassLoaders.  All heuristics have been exausted.  Class could not be found.";
            throw new UnknownClassException(msg);
        }
        return clazz;
    }

    public static boolean isAvailable(String fullyQualifiedClassName) {
        try {
            ClassUtils.forName(fullyQualifiedClassName);
            return true;
        }
        catch (UnknownClassException e) {
            return false;
        }
    }

    public static Object newInstance(String fqcn) {
        return ClassUtils.newInstance(ClassUtils.forName(fqcn));
    }

    public static Object newInstance(String fqcn, Object ... args) {
        return ClassUtils.newInstance(ClassUtils.forName(fqcn), args);
    }

    public static Object newInstance(Class clazz) {
        if (clazz == null) {
            String msg = "Class method parameter cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to instantiate class [" + clazz.getName() + "]", e);
        }
    }

    public static Object newInstance(Class clazz, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Constructor ctor = ClassUtils.getConstructor(clazz, argTypes);
        return ClassUtils.instantiate(ctor, args);
    }

    public static Constructor getConstructor(Class clazz, Class ... argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object instantiate(Constructor ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate Permission instance with constructor [" + ctor + "]";
            throw new InstantiationException(msg, e);
        }
    }
}

