/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.filter.authz;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.StringUtils;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.filter.AccessControlFilter;

public abstract class AuthorizationFilter
extends AccessControlFilter {
    private String unauthorizedUrl;

    protected String getUnauthorizedUrl() {
        return this.unauthorizedUrl;
    }

    public void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = unauthorizedUrl;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        Subject subject = this.getSubject(request, response);
        if (subject.getPrincipal() == null) {
            this.saveRequestAndRedirectToLogin(request, response);
            return false;
        }
        WebUtils.toHttp(response).setStatus(401);
        if (StringUtils.hasText(this.getUnauthorizedUrl())) {
            WebUtils.issueRedirect(request, response, this.getUnauthorizedUrl());
        }
        return false;
    }
}

