/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.webengine.gadgets;

import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.opensocial.gadgets.service.InternalGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.webengine.gadgets.InputStreamResource;
import org.nuxeo.opensocial.webengine.gadgets.render.GadgetSpecView;

@WebObject(type="gadget")
public class GadgetResource
extends InputStreamResource {
    protected static final Log log = LogFactory.getLog(GadgetResource.class);
    protected GadgetDeclaration gadget;

    public GadgetResource() {
    }

    public GadgetResource(GadgetDeclaration gadget) {
        this.gadget = gadget;
    }

    protected void initialize(Object ... args) {
        this.gadget = (GadgetDeclaration)args[0];
    }

    @GET
    @Path(value="{filename:.*}")
    public Object getGadgetFile(@PathParam(value="filename") String fileName) throws Exception {
        if (this.gadget.isExternal()) {
            return Response.seeOther((URI)this.gadget.getGadgetDefinition().toURI()).build();
        }
        InternalGadgetDescriptor iGadget = (InternalGadgetDescriptor)this.gadget;
        InputStream in = null;
        in = iGadget.getEntryPoint().equals(fileName) ? GadgetSpecView.render(iGadget, null) : (fileName.startsWith("messages_") ? GadgetSpecView.i18n.getTranslationFile(iGadget, fileName) : this.getResourceAsStream(fileName));
        if (in == null) {
            log.warn((Object)("Unable to find resource " + fileName + " in Gadget, forwarding to nxthemes-lib to make compatibility easier."));
            String base = VirtualHostHelper.getServerURL((ServletRequest)this.getContext().getRequest());
            base = base + VirtualHostHelper.getContextPath((ServletRequest)this.getContext().getRequest()).substring(1);
            return Response.seeOther((URI)new URI(base + "/nxthemes-lib/" + fileName)).build();
        }
        return this.getObject(in, fileName);
    }

    protected InputStream getResourceAsStream(String fileName) throws Exception {
        InputStream is = this.gadget.getResourceAsStream(fileName);
        if (is == null) {
            String suffix = "img/";
            if (fileName.endsWith(".css")) {
                suffix = "css/";
            } else if (fileName.endsWith(".js")) {
                suffix = "scripts/";
            }
            is = this.gadget.getResourceAsStream(suffix + fileName);
            if (is == null) {
                is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("skin/resources/" + suffix + fileName);
            }
        }
        return is;
    }

    @GET
    @Path(value="getDetails")
    @Produces(value={"text/html; charset=UTF-8"})
    public Object getDetails() {
        return this.getView("details").arg("gadget", (Object)this.gadget);
    }
}

