/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.webengine.gadgets.render;

import freemarker.cache.URLTemplateLoader;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.opensocial.gadgets.service.InternalGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

public class GadgetTemplateLoader
extends URLTemplateLoader {
    private static final Log log = LogFactory.getLog(GadgetTemplateLoader.class);

    protected URL getURL(String name) {
        if (name.startsWith("gadget://")) {
            GadgetService gs = (GadgetService)Framework.getLocalService(GadgetService.class);
            if (gs == null) {
                return null;
            }
            GadgetDeclaration gadget = gs.getGadget(name.substring("gadget://".length()));
            try {
                return gadget.getResource(((InternalGadgetDescriptor)gadget).getEntryPoint());
            }
            catch (IOException e) {
                log.debug((Object)"failed to gadget entry point", (Throwable)e);
            }
        } else {
            return GadgetTemplateLoader.class.getClassLoader().getResource("skin/resources/ftl/" + name);
        }
        return null;
    }
}

