/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.betwixt.strategy.CollectiveTypeStrategy;

public class OverrideCollectiveTypeStategy
extends CollectiveTypeStrategy {
    private final CollectiveTypeStrategy delegate;
    private final Collection collectiveClasses;
    private final Collection notCollectiveClasses;

    public OverrideCollectiveTypeStategy() {
        this(CollectiveTypeStrategy.DEFAULT);
    }

    public OverrideCollectiveTypeStategy(CollectiveTypeStrategy delegate) {
        this.delegate = delegate;
        this.collectiveClasses = new ArrayList();
        this.notCollectiveClasses = new ArrayList();
    }

    public void overrideCollective(Class type) {
        this.collectiveClasses.add(type);
    }

    public void overrideNotCollective(Class type) {
        this.notCollectiveClasses.add(type);
    }

    public boolean isCollective(Class type) {
        boolean result = this.delegate.isCollective(type);
        if (this.collectiveClasses.contains(type)) {
            result = true;
        } else if (this.notCollectiveClasses.contains(type)) {
            result = false;
        }
        return result;
    }
}

