/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.w3c.dom.Node;

public class CompactHtmlSerializer
extends DefaultHtmlSerializer {
    private static final ImmutableSortedSet<String> SPECIAL_TAGS = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object[])new String[]{"style", "pre", "script", "textarea"}).build();
    private static final String HTML_WHITESPACE = " \t\r\n";

    protected void writeText(Node n, Appendable output) throws IOException {
        if (CompactHtmlSerializer.isSpecialTag(n.getParentNode().getNodeName())) {
            super.writeText(n, output);
        } else {
            CompactHtmlSerializer.collapseWhitespace(n.getTextContent(), output);
        }
    }

    protected void writeComment(Node n, Appendable output) throws IOException {
        if (CompactHtmlSerializer.isSpecialTag(n.getParentNode().getNodeName())) {
            super.writeComment(n, output);
        } else if (this.isIeConditionalComment(n)) {
            super.writeComment(n, output);
        }
    }

    private boolean isIeConditionalComment(Node n) {
        String comment = n.getTextContent();
        return comment.indexOf("[if ") != -1 && comment.indexOf("[endif]") != -1;
    }

    static boolean isSpecialTag(String tagName) {
        return SPECIAL_TAGS.contains((Object)tagName);
    }

    static void collapseWhitespace(String str, Appendable output) throws IOException {
        str = StringUtils.stripStart((String)str, (String)HTML_WHITESPACE);
        boolean seenWhitespace = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (HTML_WHITESPACE.indexOf(c) != -1) {
                seenWhitespace = true;
                continue;
            }
            if (seenWhitespace) {
                output.append(' ');
            }
            output.append(c);
            seenWhitespace = false;
        }
    }
}

