/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements RequestAuthenticationInfo {
    private static final Set<String> KNOWN_ATTRIBUTES = ImmutableSet.of((Object)"type", (Object)"view", (Object)"href", (Object)"preferred_height", (Object)"preferred_width", (Object)"authz", (Object[])new String[]{"quirks", "sign_owner", "sign_viewer"});
    private final Uri base;
    private final String name;
    private final ContentType type;
    private final String rawType;
    private Uri href;
    private final boolean quirks;
    private final int preferredHeight;
    private final int preferredWidth;
    private String content;
    private final boolean needsUserPrefSubstitution;
    private final AuthType authType;
    private final boolean signOwner;
    private final boolean signViewer;
    private final Map<String, String> attributes;
    private final PipelinedData pipelinedData;

    public View(String name, List<Element> elements, Uri base) throws SpecParserException {
        this.name = name;
        this.base = base;
        boolean quirks = true;
        Uri href = null;
        String contentType = null;
        ContentType type = null;
        int preferredHeight = 0;
        int preferredWidth = 0;
        String auth = null;
        boolean signOwner = true;
        boolean signViewer = true;
        HashMap attributes = Maps.newHashMap();
        StringBuilder content = new StringBuilder();
        boolean needOwner = false;
        boolean needViewer = false;
        PipelinedData pipelinedData = null;
        for (Element element : elements) {
            contentType = XmlUtil.getAttribute((Node)element, (String)"type");
            if (contentType != null) {
                ContentType newType = ContentType.parse(contentType);
                if (type != null && newType != type) {
                    throw new SpecParserException("You may not mix content types in the same view.");
                }
                type = newType;
            }
            href = XmlUtil.getUriAttribute((Node)element, (String)"href", href);
            quirks = XmlUtil.getBoolAttribute((Node)element, (String)"quirks", (boolean)quirks);
            preferredHeight = XmlUtil.getIntAttribute((Node)element, (String)"preferred_height");
            preferredWidth = XmlUtil.getIntAttribute((Node)element, (String)"preferred_width");
            auth = XmlUtil.getAttribute((Node)element, (String)"authz", auth);
            signOwner = XmlUtil.getBoolAttribute((Node)element, (String)"sign_owner", (boolean)signOwner);
            signViewer = XmlUtil.getBoolAttribute((Node)element, (String)"sign_viewer", (boolean)signViewer);
            content.append(element.getTextContent());
            NamedNodeMap attrs = element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (KNOWN_ATTRIBUTES.contains(attr.getNodeName())) continue;
                attributes.put(attr.getNodeName(), attr.getNodeValue());
            }
            if (href == null || type == ContentType.URL) continue;
            pipelinedData = new PipelinedData(element, base);
            needOwner = needOwner || pipelinedData.needsOwner();
            needViewer = needViewer || pipelinedData.needsViewer();
        }
        this.content = content.toString();
        this.needsUserPrefSubstitution = this.content.contains("__UP_");
        this.quirks = quirks;
        this.href = href;
        this.rawType = contentType == null ? "html" : contentType;
        this.type = type == null ? ContentType.HTML : type;
        this.preferredHeight = preferredHeight;
        this.preferredWidth = preferredWidth;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.pipelinedData = pipelinedData;
        this.authType = AuthType.parse(auth);
        this.signOwner = signOwner;
        this.signViewer = signViewer;
        if (type == ContentType.URL && this.href == null) {
            throw new SpecParserException("Content@href must be set when Content@type is \"url\".");
        }
        if (needOwner && (!this.signOwner || this.authType == AuthType.NONE)) {
            throw new SpecParserException("Must sign by owner to request owner.");
        }
        if (needViewer && (!this.signViewer || this.authType == AuthType.NONE)) {
            throw new SpecParserException("Must sign by viewer to request viewer.");
        }
    }

    private View(View view, Substitutions substituter) {
        this.needsUserPrefSubstitution = view.needsUserPrefSubstitution;
        this.name = view.name;
        this.rawType = view.rawType;
        this.type = view.type;
        this.quirks = view.quirks;
        this.preferredHeight = view.preferredHeight;
        this.preferredWidth = view.preferredWidth;
        this.authType = view.authType;
        this.signOwner = view.signOwner;
        this.signViewer = view.signViewer;
        this.content = substituter.substituteString(view.content);
        this.base = view.base;
        this.href = this.base.resolve(substituter.substituteUri(view.href));
        HashMap attributes = Maps.newHashMap();
        for (Map.Entry<String, String> entry : view.attributes.entrySet()) {
            attributes.put(entry.getKey(), substituter.substituteString(entry.getValue()));
        }
        this.attributes = Collections.unmodifiableMap(attributes);
        this.pipelinedData = view.pipelinedData == null ? null : view.pipelinedData.substitute(substituter);
    }

    public String getName() {
        return this.name;
    }

    public ContentType getType() {
        return this.type;
    }

    public String getRawType() {
        return this.rawType;
    }

    @Override
    public Uri getHref() {
        return this.href;
    }

    public boolean getQuirks() {
        return this.quirks;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public String getContent() {
        return this.content;
    }

    public void setHrefContent(String content) {
        this.content = content;
        this.href = null;
    }

    public boolean needsUserPrefSubstitution() {
        return this.needsUserPrefSubstitution;
    }

    @Override
    public AuthType getAuthType() {
        return this.authType;
    }

    @Override
    public boolean isSignOwner() {
        return this.signOwner;
    }

    @Override
    public boolean isSignViewer() {
        return this.signViewer;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public PipelinedData getPipelinedData() {
        return this.pipelinedData;
    }

    public View substitute(Substitutions substituter) {
        return new View(this, substituter);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Content").append(" type='").append(this.rawType).append('\'').append(" href='").append(this.href).append('\'').append(" view='").append(this.name).append('\'').append(" quirks='").append(this.quirks).append('\'').append(" preferred_height='").append(this.preferredHeight).append('\'').append(" preferred_width='").append(this.preferredWidth).append('\'').append(" authz=").append(this.authType.toString().toLowerCase()).append('\'');
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            buf.append(entry.getKey()).append("='").append(entry.getValue()).append('\'');
        }
        buf.append("'>").append(this.content).append("</Content>");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        HTML("html"),
        URL("url"),
        HTML_SANITIZED("x-html-sanitized");

        private String viewName;

        private ContentType(String viewName) {
            this.viewName = viewName;
        }

        public static ContentType parse(String viewName) {
            viewName = viewName.toLowerCase().trim();
            for (ContentType enumVal : ContentType.values()) {
                if (!enumVal.viewName.equals(viewName)) continue;
                return enumVal;
            }
            return HTML;
        }

        public String toString() {
            return this.viewName;
        }
    }
}

