/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jsecurity.authc.Account;
import org.jsecurity.authc.SimpleAccount;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.AuthorizingAccount;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.SimpleRole;
import org.jsecurity.authz.UnauthorizedException;
import org.jsecurity.subject.PrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthorizingAccount
extends SimpleAccount
implements AuthorizingAccount {
    protected Set<SimpleRole> simpleRoles;

    public SimpleAuthorizingAccount() {
    }

    public SimpleAuthorizingAccount(Object principal, Object credentials, String realmName) {
        super(principal, credentials, realmName);
    }

    public SimpleAuthorizingAccount(Collection principals, Object credentials, String realmName) {
        super(principals, credentials, realmName);
    }

    public SimpleAuthorizingAccount(PrincipalCollection principals, Object credentials) {
        super(principals, credentials);
    }

    public SimpleAuthorizingAccount(Object principal, Object credentials, String realmName, Set<String> roleNames, Set<Permission> permissions) {
        this(principal, credentials, realmName);
        this.addRoles(roleNames);
        if (permissions != null && !permissions.isEmpty()) {
            this.addPrivateRole(this.getPrincipals(), permissions);
        }
    }

    public SimpleAuthorizingAccount(Collection principals, Object credentials, String realmName, Set<String> roleNames, Set<Permission> permissions) {
        this(principals, credentials, realmName);
        this.addRoles(roleNames);
        if (permissions != null && !permissions.isEmpty()) {
            this.addPrivateRole(this.getPrincipals(), permissions);
        }
    }

    public SimpleAuthorizingAccount(PrincipalCollection principals, Object credentials, String realmName, Set<String> roleNames, Set<Permission> permissions) {
        this((Object)principals, credentials, realmName);
        this.addRoles(roleNames);
        if (permissions != null && !permissions.isEmpty()) {
            this.addPrivateRole(this.getPrincipals(), permissions);
        }
    }

    public void merge(Account otherAccount) {
        SimpleAuthorizingAccount other;
        Set<SimpleRole> otherRoles;
        super.merge(otherAccount);
        if (otherAccount instanceof SimpleAuthorizingAccount && (otherRoles = (other = (SimpleAuthorizingAccount)otherAccount).getSimpleRoles()) != null && !otherRoles.isEmpty()) {
            for (SimpleRole otherRole : otherRoles) {
                this.merge(otherRole);
            }
        }
    }

    protected void merge(SimpleRole role) {
        SimpleRole existing = this.getRole(role.getName());
        if (existing != null) {
            Set<Permission> rolePerms = role.getPermissions();
            if (rolePerms != null && !rolePerms.isEmpty()) {
                existing.addAll(rolePerms);
            }
        } else {
            this.add(role);
        }
    }

    protected void addPrivateRole(PrincipalCollection principals, Collection<Permission> perms) {
        SimpleRole privateRole = this.createPrivateRole(principals);
        if (perms != null && !perms.isEmpty()) {
            privateRole.addAll(perms);
        }
        this.add(privateRole);
    }

    protected String getPrivateRoleName(PrincipalCollection principals) {
        return this.getClass().getName() + "_PRIVATE_ROLE_" + PrincipalCollection.class.getName();
    }

    protected SimpleRole createPrivateRole(PrincipalCollection principals) {
        String privateRoleName = this.getPrivateRoleName(principals);
        return new SimpleRole(privateRoleName);
    }

    public Set<SimpleRole> getSimpleRoles() {
        return this.simpleRoles;
    }

    public void setSimpleRoles(Set<SimpleRole> simpleRoles) {
        this.simpleRoles = simpleRoles;
    }

    public SimpleRole getRole(String name) {
        Set<SimpleRole> roles = this.getSimpleRoles();
        if (roles != null && !roles.isEmpty()) {
            for (SimpleRole role : roles) {
                if (!role.getName().equals(name)) continue;
                return role;
            }
        }
        return null;
    }

    public Set<Permission> getPermissions() {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (SimpleRole role : this.simpleRoles) {
            permissions.addAll(role.getPermissions());
        }
        return permissions;
    }

    public Set<String> getRolenames() {
        HashSet<String> rolenames = new HashSet<String>();
        for (SimpleRole role : this.simpleRoles) {
            rolenames.add(role.getName());
        }
        return rolenames;
    }

    @Override
    public void addRole(String roleName) {
        SimpleRole existing = this.getRole(roleName);
        if (existing == null) {
            SimpleRole role = new SimpleRole(roleName);
            this.add(role);
        }
    }

    public void add(SimpleRole role) {
        Set<SimpleRole> roles = this.getSimpleRoles();
        if (roles == null) {
            roles = new LinkedHashSet<SimpleRole>();
            this.setSimpleRoles(roles);
        }
        roles.add(role);
    }

    public void addRoles(Set<String> roleNames) {
        if (roleNames != null && !roleNames.isEmpty()) {
            for (String name : roleNames) {
                this.addRole(name);
            }
        }
    }

    public void addAll(Collection<SimpleRole> roles) {
        if (roles != null && !roles.isEmpty()) {
            Set<SimpleRole> existingRoles = this.getSimpleRoles();
            if (existingRoles == null) {
                existingRoles = new LinkedHashSet<SimpleRole>(roles.size());
                this.setSimpleRoles(existingRoles);
            }
            existingRoles.addAll(roles);
        }
    }

    @Override
    public boolean hasRole(String roleName) {
        return this.getRole(roleName) != null;
    }

    @Override
    public boolean isPermitted(Permission permission) {
        Set<SimpleRole> roles = this.getSimpleRoles();
        if (roles != null && !roles.isEmpty()) {
            for (SimpleRole role : roles) {
                if (!role.isPermitted(permission)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean[] hasRoles(List<String> roleIdentifiers) {
        boolean[] result;
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            int size = roleIdentifiers.size();
            result = new boolean[size];
            int i = 0;
            for (String roleName : roleIdentifiers) {
                result[i++] = this.hasRole(roleName);
            }
        } else {
            result = new boolean[]{};
        }
        return result;
    }

    @Override
    public boolean hasAllRoles(Collection<String> roleIdentifiers) {
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            for (String roleName : roleIdentifiers) {
                if (this.hasRole(roleName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean[] isPermitted(List<Permission> permissions) {
        boolean[] result;
        if (permissions != null && !permissions.isEmpty()) {
            int size = permissions.size();
            result = new boolean[size];
            int i = 0;
            for (Permission p : permissions) {
                result[i++] = this.isPermitted(p);
            }
        } else {
            result = new boolean[]{};
        }
        return result;
    }

    @Override
    public boolean isPermittedAll(Collection<Permission> permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission p : permissions) {
                if (this.isPermitted(p)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void checkPermission(Permission permission) throws AuthorizationException {
        if (!this.isPermitted(permission)) {
            String msg = "User is not permitted [" + permission + "]";
            throw new UnauthorizedException(msg);
        }
    }

    @Override
    public void checkPermissions(Collection<Permission> permissions) throws AuthorizationException {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission p : permissions) {
                this.checkPermission(p);
            }
        }
    }

    @Override
    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            String msg = "User does not have role [" + role + "]";
            throw new UnauthorizedException(msg);
        }
    }

    @Override
    public void checkRoles(Collection<String> roles) {
        if (roles != null && !roles.isEmpty()) {
            for (String roleName : roles) {
                this.checkRole(roleName);
            }
        }
    }
}

