/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.mgt;

import java.util.Collection;
import java.util.List;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.Authorizer;
import org.jsecurity.authz.ModularRealmAuthorizer;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.permission.PermissionResolver;
import org.jsecurity.authz.permission.PermissionResolverAware;
import org.jsecurity.mgt.AuthenticatingSecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizingSecurityManager
extends AuthenticatingSecurityManager
implements PermissionResolverAware {
    protected Authorizer authorizer;

    public AuthorizingSecurityManager() {
        this.ensureAuthorizer();
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(Authorizer authorizer) {
        if (authorizer == null) {
            String msg = "Authorizer argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.authorizer = authorizer;
    }

    protected void ensureAuthorizer() {
        Authorizer authorizer = this.getAuthorizer();
        if (authorizer == null) {
            authorizer = this.createAuthorizer();
            this.setAuthorizer(authorizer);
        }
    }

    protected Authorizer createAuthorizer() {
        return new ModularRealmAuthorizer();
    }

    @Override
    public void setPermissionResolver(PermissionResolver permissionResolver) {
        Authorizer authz = this.getAuthorizer();
        if (!(authz instanceof PermissionResolverAware)) {
            String msg = "Underlying Authorizer instance does not implement the " + PermissionResolverAware.class.getName() + " interface.  This is required to support " + "passthrough configuration of a PermissionResolver.";
            throw new IllegalStateException(msg);
        }
        ((PermissionResolverAware)((Object)authz)).setPermissionResolver(permissionResolver);
    }

    @Override
    public void setRealms(Collection<Realm> realms) {
        super.setRealms(realms);
        Authorizer authz = this.getAuthorizer();
        if (authz instanceof ModularRealmAuthorizer) {
            ((ModularRealmAuthorizer)authz).setRealms(realms);
        }
    }

    protected void beforeAuthorizerDestroyed() {
    }

    protected void destroyAuthorizer() {
        LifecycleUtils.destroy(this.getAuthorizer());
    }

    @Override
    protected void beforeAuthenticatorDestroyed() {
        this.beforeAuthorizerDestroyed();
        this.destroyAuthorizer();
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, String permissionString) {
        this.ensureRealms();
        return this.getAuthorizer().isPermitted(principals, permissionString);
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.ensureRealms();
        return this.getAuthorizer().isPermitted(principals, permission);
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, String ... permissions) {
        this.ensureRealms();
        return this.getAuthorizer().isPermitted(principals, permissions);
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, List<Permission> permissions) {
        this.ensureRealms();
        return this.getAuthorizer().isPermitted(principals, permissions);
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principals, String ... permissions) {
        this.ensureRealms();
        return this.getAuthorizer().isPermittedAll(principals, permissions);
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principals, Collection<Permission> permissions) {
        this.ensureRealms();
        return this.getAuthorizer().isPermittedAll(principals, permissions);
    }

    @Override
    public void checkPermission(PrincipalCollection principals, String permission) throws AuthorizationException {
        this.ensureRealms();
        this.getAuthorizer().checkPermission(principals, permission);
    }

    @Override
    public void checkPermission(PrincipalCollection principals, Permission permission) throws AuthorizationException {
        this.ensureRealms();
        this.getAuthorizer().checkPermission(principals, permission);
    }

    @Override
    public void checkPermissions(PrincipalCollection principals, String ... permissions) throws AuthorizationException {
        this.ensureRealms();
        this.getAuthorizer().checkPermissions(principals, permissions);
    }

    @Override
    public void checkPermissions(PrincipalCollection principals, Collection<Permission> permissions) throws AuthorizationException {
        this.ensureRealms();
        this.getAuthorizer().checkPermissions(principals, permissions);
    }

    @Override
    public boolean hasRole(PrincipalCollection principals, String roleIdentifier) {
        this.ensureRealms();
        return this.getAuthorizer().hasRole(principals, roleIdentifier);
    }

    @Override
    public boolean[] hasRoles(PrincipalCollection principals, List<String> roleIdentifiers) {
        this.ensureRealms();
        return this.getAuthorizer().hasRoles(principals, roleIdentifiers);
    }

    @Override
    public boolean hasAllRoles(PrincipalCollection principals, Collection<String> roleIdentifiers) {
        this.ensureRealms();
        return this.getAuthorizer().hasAllRoles(principals, roleIdentifiers);
    }

    @Override
    public void checkRole(PrincipalCollection principals, String role) throws AuthorizationException {
        this.ensureRealms();
        this.getAuthorizer().checkRole(principals, role);
    }

    @Override
    public void checkRoles(PrincipalCollection principals, Collection<String> roles) throws AuthorizationException {
        this.ensureRealms();
        this.getAuthorizer().checkRoles(principals, roles);
    }
}

