/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.mgt;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.cache.CacheManagerAware;
import org.jsecurity.mgt.CachingSecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.realm.text.PropertiesRealm;
import org.jsecurity.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealmSecurityManager
extends CachingSecurityManager {
    private static final Log log = LogFactory.getLog(RealmSecurityManager.class);
    protected Collection<Realm> realms;

    public void setRealm(Realm realm) {
        if (realm == null) {
            throw new IllegalArgumentException("Realm argument cannot be null");
        }
        ArrayList<Realm> realms = new ArrayList<Realm>(1);
        realms.add(realm);
        this.setRealms(realms);
    }

    public void setRealms(Collection<Realm> realms) {
        if (realms == null) {
            throw new IllegalArgumentException("Realms collection argument cannot be null.");
        }
        if (realms.isEmpty()) {
            throw new IllegalArgumentException("Realms collection argument cannot be empty.");
        }
        this.realms = realms;
        this.applyCacheManagerToRealms();
    }

    protected void ensureRealms() {
        Collection<Realm> realms = this.getRealms();
        if (realms == null || realms.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No Realms configured.  Defaulting to failsafe PropertiesRealm.");
            }
            Realm realm = this.createDefaultRealm();
            this.setRealm(realm);
        }
    }

    protected Realm createDefaultRealm() {
        CacheManager cacheManager = this.getCacheManager();
        PropertiesRealm realm = cacheManager != null ? new PropertiesRealm(cacheManager) : new PropertiesRealm();
        return realm;
    }

    public Collection<Realm> getRealms() {
        return this.realms;
    }

    protected void applyCacheManagerToRealms() {
        CacheManager cacheManager = this.getCacheManager();
        Collection<Realm> realms = this.getRealms();
        if (cacheManager != null && realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof CacheManagerAware)) continue;
                ((CacheManagerAware)((Object)realm)).setCacheManager(cacheManager);
            }
        }
    }

    @Override
    protected void afterCacheManagerSet() {
        this.applyCacheManagerToRealms();
    }

    @Override
    protected void beforeCacheManagerDestroyed() {
        this.beforeRealmsDestroyed();
        this.destroyRealms();
    }

    protected void beforeRealmsDestroyed() {
    }

    protected void destroyRealms() {
        LifecycleUtils.destroy(this.getRealms());
        this.realms = null;
    }
}

