/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.attr;

import java.beans.PropertyEditor;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.JSecurityException;
import org.jsecurity.util.ClassUtils;
import org.jsecurity.web.attr.WebAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebAttribute<T>
implements WebAttribute<T> {
    public static final String DEFAULT_NAME = "name";
    private static final Log log = LogFactory.getLog(AbstractWebAttribute.class);
    protected String name = "name";
    protected boolean checkRequestParams = true;
    protected boolean checkRequestParamsFirst = true;
    protected boolean mutable = true;
    private Class<? extends PropertyEditor> editorClass = null;

    public AbstractWebAttribute() {
        this(DEFAULT_NAME, true);
    }

    public AbstractWebAttribute(String name) {
        this(name, true);
    }

    public AbstractWebAttribute(String name, boolean checkRequestParams) {
        this.setName(name);
        this.setCheckRequestParams(checkRequestParams);
    }

    public AbstractWebAttribute(String name, Class<? extends PropertyEditor> editorClass) {
        this(name, true, editorClass);
    }

    public AbstractWebAttribute(String name, boolean checkRequestParams, Class<? extends PropertyEditor> editorClass) {
        this.setName(name);
        this.setCheckRequestParams(checkRequestParams);
        this.setEditorClass(editorClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCheckRequestParams() {
        return this.checkRequestParams;
    }

    public void setCheckRequestParams(boolean checkRequestParams) {
        this.checkRequestParams = checkRequestParams;
    }

    public boolean isCheckRequestParamsFirst() {
        return this.checkRequestParamsFirst;
    }

    public void setCheckRequestParamsFirst(boolean checkRequestParamsFirst) {
        this.checkRequestParamsFirst = checkRequestParamsFirst;
    }

    public Class<? extends PropertyEditor> getEditorClass() {
        return this.editorClass;
    }

    public void setEditorClass(Class<? extends PropertyEditor> editorClass) {
        this.editorClass = editorClass;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    protected T fromStringValue(String stringValue) {
        Class<PropertyEditor> clazz = this.getEditorClass();
        if (clazz == null) {
            try {
                return (T)stringValue;
            }
            catch (Exception e) {
                String msg = "If the type is not String, you must specify the 'editorClass' property.";
                throw new JSecurityException(msg, e);
            }
        }
        PropertyEditor editor = (PropertyEditor)ClassUtils.newInstance(this.getEditorClass());
        editor.setAsText(stringValue);
        Object value = editor.getValue();
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            String msg = "Returned value from PropertyEditor does not match the specified type.";
            throw new JSecurityException(msg, e);
        }
    }

    protected String toStringValue(T value) {
        Class<PropertyEditor> clazz = this.getEditorClass();
        if (clazz == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No 'editorClass' property set - returning value.toString() as the string value for method argument.");
            }
            return value.toString();
        }
        PropertyEditor editor = (PropertyEditor)ClassUtils.newInstance(this.getEditorClass());
        editor.setValue(value);
        return editor.getAsText();
    }

    protected T getFromRequestParam(ServletRequest request) {
        T value = null;
        String paramName = this.getName();
        String paramValue = request.getParameter(paramName);
        if (paramValue != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found string value [" + paramValue + "] from HttpServletRequest parameter [" + paramName + "]"));
            }
            value = this.fromStringValue(paramValue);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No string value found in the HttpServletRequest under parameter named [" + paramName + "]"));
        }
        return value;
    }

    @Override
    public final T retrieveValue(ServletRequest request, ServletResponse response) {
        T value = null;
        if (this.isCheckRequestParams() && this.isCheckRequestParamsFirst()) {
            value = this.getFromRequestParam(request);
        }
        if (value == null) {
            value = this.onRetrieveValue(request, response);
        }
        if (value == null && this.isCheckRequestParams() && !this.isCheckRequestParamsFirst()) {
            value = this.getFromRequestParam(request);
        }
        return value;
    }

    protected abstract T onRetrieveValue(ServletRequest var1, ServletResponse var2);

    @Override
    public void storeValue(T value, ServletRequest request, ServletResponse response) {
        if (value == null && this.isMutable()) {
            this.removeValue(request, response);
            return;
        }
        if (!this.isMutable()) {
            T existing = this.onRetrieveValue(request, response);
            if (existing != null && log.isDebugEnabled()) {
                log.debug((Object)("Found existing value stored under name [" + this.getName() + "].  Ignoring new " + "storage request - this store is immutable after the value has initially been set."));
            }
            return;
        }
        this.onStoreValue(value, request, response);
    }

    protected abstract void onStoreValue(T var1, ServletRequest var2, ServletResponse var3);
}

