/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.SnippetProducer;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ErrorReporter {
    static MessageLevel reportErrors(Map<InputSource, CharSequence> inputs, MessageContext mc, MessageQueue mq, Appendable out) throws IOException {
        MessageLevel max = MessageLevel.values()[0];
        SnippetProducer sp = new SnippetProducer(inputs, mc);
        Map<MessageTypeInt, Integer> counts = Maps.newHashMap();
        for (Message msg : ErrorReporter.sortMessages(mq.getMessages())) {
            counts.put(msg.getMessageType(), counts.containsKey(msg.getMessageType()) ? (Integer)counts.get(msg.getMessageType()) + 1 : 1);
            MessageLevel level = msg.getMessageLevel();
            if (level.compareTo(max) > 0) {
                max = level;
            }
            String snippet = sp.getSnippet(msg);
            out.append(level.name() + " : " + msg.format(mc) + (snippet != null ? "\n" + snippet : "") + "\n");
        }
        List countsInOrder = Lists.newArrayList(counts.entrySet());
        Collections.sort(countsInOrder, new Comparator<Map.Entry<MessageTypeInt, Integer>>(){

            @Override
            public int compare(Map.Entry<MessageTypeInt, Integer> a, Map.Entry<MessageTypeInt, Integer> b) {
                int delta = a.getValue() - b.getValue();
                if (delta != 0) {
                    return delta;
                }
                return a.getKey().name().compareTo(b.getKey().name());
            }
        });
        for (Map.Entry e : countsInOrder) {
            out.append(String.format("%3d %s\n", e.getValue(), ((MessageTypeInt)e.getKey()).name()));
        }
        return max;
    }

    static List<Message> sortMessages(List<Message> messages) {
        List<Message> sorted = Lists.newArrayList(messages);
        Collections.sort(sorted, new Comparator<Message>(){

            @Override
            public int compare(Message a, Message b) {
                FilePosition pos;
                int delta;
                MessagePart a0 = ErrorReporter.firstPartOf(a);
                MessagePart b0 = ErrorReporter.firstPartOf(b);
                InputSource aSrc = this.toInputSource(a0);
                InputSource bSrc = this.toInputSource(b0);
                if (aSrc != null && bSrc != null && (delta = aSrc.getUri().compareTo(bSrc.getUri())) != 0) {
                    return delta;
                }
                long aSPos = 0x80000000L;
                long aEPos = 0x80000000L;
                long bSPos = 0x80000000L;
                long bEPos = 0x80000000L;
                if (a0 instanceof FilePosition) {
                    pos = (FilePosition)a0;
                    aSPos = pos.startCharInFile();
                    aEPos = pos.endCharInFile();
                } else if (a0 instanceof InputSource) {
                    aEPos = -1L;
                    aSPos = -1L;
                }
                if (b0 instanceof FilePosition) {
                    pos = (FilePosition)b0;
                    bSPos = pos.startCharInFile();
                    bEPos = pos.endCharInFile();
                } else if (b0 instanceof InputSource) {
                    bEPos = -1L;
                    bSPos = -1L;
                }
                int delta2 = Long.signum(aSPos - bSPos);
                if (delta2 != 0) {
                    return delta2;
                }
                delta2 = Long.signum(aEPos - bEPos);
                if (delta2 != 0) {
                    return delta2;
                }
                StringBuilder aBuf = new StringBuilder();
                StringBuilder bBuf = new StringBuilder();
                MessageContext mc = new MessageContext();
                try {
                    a0.format(mc, aBuf);
                    b0.format(mc, bBuf);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return aBuf.toString().compareTo(bBuf.toString());
            }

            private InputSource toInputSource(MessagePart p) {
                if (p instanceof FilePosition) {
                    return ((FilePosition)p).source();
                }
                if (p instanceof InputSource) {
                    return (InputSource)p;
                }
                return null;
            }
        });
        return sorted;
    }

    private static MessagePart firstPartOf(Message m) {
        List<MessagePart> parts = m.getMessageParts();
        return parts.isEmpty() ? null : parts.get(0);
    }

    private ErrorReporter() {
    }
}

