/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.config.AllowedFileResolver;
import com.google.caja.config.ConfigUtil;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Maps;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CssPropertyPatterns {
    private final CssSchema schema;
    public static Set<Name> HISTORY_INSENSITIVE_STYLE_WHITELIST = Sets.newLinkedHashSet(Name.css("display"), Name.css("filter"), Name.css("float"), Name.css("height"), Name.css("left"), Name.css("opacity"), Name.css("overflow"), Name.css("position"), Name.css("right"), Name.css("top"), Name.css("visibility"), Name.css("width"), Name.css("padding-left"), Name.css("padding-right"), Name.css("padding-top"), Name.css("padding-bottom"));
    private static final Map<String, String> BUILTINS = Maps.newHashMap();

    public CssPropertyPatterns(CssSchema schema) {
        this.schema = schema;
    }

    public String cssPropertyToPattern(CssPropertySignature sig) {
        Pattern p = this.sigToPattern(sig);
        if (p == null) {
            return null;
        }
        p = new Concatenation(Arrays.asList(new Snippet("^\\s*"), p, new Snippet("$"))).optimize();
        StringBuilder out = new StringBuilder();
        out.append('/');
        p.render(out);
        out.append("/i");
        return out.toString();
    }

    private Pattern sigToPattern(CssPropertySignature sig) {
        if (sig instanceof CssPropertySignature.LiteralSignature) {
            return CssPropertyPatterns.litToPattern((CssPropertySignature.LiteralSignature)sig);
        }
        if (sig instanceof CssPropertySignature.RepeatedSignature) {
            return this.repToPattern((CssPropertySignature.RepeatedSignature)sig);
        }
        if (sig instanceof CssPropertySignature.PropertyRefSignature) {
            return this.refToPattern((CssPropertySignature.PropertyRefSignature)sig);
        }
        if (sig instanceof CssPropertySignature.SeriesSignature) {
            return this.seriesToPattern((CssPropertySignature.SeriesSignature)sig);
        }
        if (sig instanceof CssPropertySignature.SymbolSignature) {
            return this.symbolToPattern((CssPropertySignature.SymbolSignature)sig);
        }
        if (sig instanceof CssPropertySignature.SetSignature || sig instanceof CssPropertySignature.ExclusiveSetSignature) {
            return this.setToPattern(sig);
        }
        return null;
    }

    private static Pattern litToPattern(CssPropertySignature.LiteralSignature lit) {
        StringBuilder regex = new StringBuilder();
        Escaping.escapeRegex((CharSequence)lit.getValue(), false, false, regex);
        regex.append("\\s+");
        return new Snippet(regex.toString());
    }

    private Pattern repToPattern(CssPropertySignature.RepeatedSignature sig) {
        CssPropertySignature rep = sig.getRepeatedSignature();
        if (rep instanceof CssPropertySignature.ExclusiveSetSignature) {
            return this.exclusiveToPattern(rep);
        }
        Pattern repeatedPattern = this.sigToPattern(rep);
        if (repeatedPattern == null) {
            return null;
        }
        return new Repetition(repeatedPattern, sig.minCount, sig.maxCount);
    }

    private Pattern refToPattern(CssPropertySignature.PropertyRefSignature sig) {
        CssSchema.CssPropertyInfo p = this.schema.getCssProperty(sig.getPropertyName());
        return p != null ? this.sigToPattern(p.sig) : null;
    }

    private Pattern seriesToPattern(CssPropertySignature.SeriesSignature sig) {
        ArrayList<Pattern> children = new ArrayList<Pattern>();
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            Pattern childP = this.sigToPattern(cssPropertySignature);
            if (childP == null) {
                return null;
            }
            children.add(childP);
        }
        return new Concatenation(children);
    }

    private Pattern symbolToPattern(CssPropertySignature.SymbolSignature sig) {
        Name symbolName = sig.getValue();
        Pattern builtinMatch = this.builtinToPattern(symbolName);
        if (builtinMatch != null) {
            return builtinMatch;
        }
        CssSchema.SymbolInfo s = this.schema.getSymbol(symbolName);
        return s != null ? this.sigToPattern(s.sig) : null;
    }

    private Pattern setToPattern(CssPropertySignature sig) {
        if (sig.children().isEmpty()) {
            return null;
        }
        ArrayList<Pattern> children = new ArrayList<Pattern>();
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            Pattern childP = this.sigToPattern(cssPropertySignature);
            if (childP == null) continue;
            children.add(childP);
        }
        if (children.isEmpty()) {
            return null;
        }
        return new Union(children);
    }

    private Pattern exclusiveToPattern(CssPropertySignature sig) {
        if (sig.children().isEmpty()) {
            return null;
        }
        ArrayList<Pattern> children = new ArrayList<Pattern>();
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            Pattern childP = this.sigToPattern(cssPropertySignature);
            if (childP == null) continue;
            children.add(childP);
        }
        if (children.isEmpty()) {
            return null;
        }
        return new Repetition(new Union(children), 1, Integer.MAX_VALUE);
    }

    private Pattern builtinToPattern(Name name) {
        String pattern = BUILTINS.get(name.getCanonicalForm());
        if (pattern == null && name.getCanonicalForm().contains(":")) {
            System.err.println("Failing detail check on " + name);
        }
        return pattern != null ? new Snippet(pattern + "\\s+") : null;
    }

    public static String commonSuffix(String a, String b) {
        int i;
        int m = a.length();
        int n = b.length();
        int k = Math.min(m, n);
        for (i = 0; i < k && a.charAt(m - i - 1) == b.charAt(n - i - 1); ++i) {
        }
        return a.substring(m - i, m);
    }

    public static void generatePatterns(CssSchema schema, Appendable out) throws IOException {
        FilePosition unk = FilePosition.UNKNOWN;
        CssPropertyPatterns pp = new CssPropertyPatterns(schema);
        ArrayList<CssSchema.CssPropertyInfo> props = new ArrayList<CssSchema.CssPropertyInfo>(schema.getCssProperties());
        Collections.sort(props, new Comparator<CssSchema.CssPropertyInfo>(){

            @Override
            public int compare(CssSchema.CssPropertyInfo a, CssSchema.CssPropertyInfo b) {
                return a.name.compareTo(b.name);
            }
        });
        Map<String, int[]> constantPoolMap = Maps.newHashMap();
        ArrayList<Pair<CssSchema.CssPropertyInfo, String>> patterns = new ArrayList<Pair<CssSchema.CssPropertyInfo, String>>();
        ArrayList<RegexpLiteral> constantPool = new ArrayList<RegexpLiteral>();
        for (CssSchema.CssPropertyInfo prop : props) {
            String pattern = pp.cssPropertyToPattern(prop.sig);
            if (!schema.isPropertyAllowed(prop.name) || pattern == null || "(?:inherit\\s+)".equals(pattern)) continue;
            patterns.add(Pair.pair(prop, pattern));
            int[] pool = (int[])constantPoolMap.get(pattern);
            if (pool == null) {
                constantPoolMap.put(pattern, new int[]{-1});
                continue;
            }
            if (pool[0] != -1) continue;
            pool[0] = constantPool.size();
            constantPool.add(new RegexpLiteral(unk, pattern));
        }
        Declaration constantPoolDecl = null;
        if (!constantPool.isEmpty()) {
            constantPoolDecl = (Declaration)QuasiBuilder.substV("var c = @constantPool;", "constantPool", new ArrayConstructor(unk, constantPool));
        }
        ArrayList<Pair<Literal, Expression>> members = new ArrayList<Pair<Literal, Expression>>();
        ArrayList<Pair<Literal, Expression>> alternates = new ArrayList<Pair<Literal, Expression>>();
        for (Pair pair : patterns) {
            int poolIndex = ((int[])constantPoolMap.get(pair.b))[0];
            RegexpLiteral re = poolIndex < 0 ? new RegexpLiteral(unk, (String)pair.b) : (Expression)QuasiBuilder.substV("c[@i]", "i", new IntegerLiteral(unk, poolIndex));
            StringLiteral name = StringLiteral.valueOf(unk, ((CssSchema.CssPropertyInfo)pair.a).name.getCanonicalForm());
            members.add(Pair.pair(name, re));
            String dom2property = CssPropertyPatterns.propertyNameToDom2Property(((CssSchema.CssPropertyInfo)pair.a).name);
            AbstractParseTreeNode altNames = null;
            for (String altDom2Property : ((CssSchema.CssPropertyInfo)pair.a).dom2properties) {
                if (altDom2Property.equals(dom2property)) continue;
                if (altNames == null) {
                    altNames = new ArrayConstructor(unk, Collections.emptyList());
                    alternates.add(Pair.pair(StringLiteral.valueOf(unk, dom2property), altNames));
                }
                altNames.appendChild(StringLiteral.valueOf(unk, altDom2Property));
            }
        }
        ArrayList<Pair<Literal, Expression>> historyInsensitiveStyleWhitelistEls = new ArrayList<Pair<Literal, Expression>>();
        for (Name propertyName : HISTORY_INSENSITIVE_STYLE_WHITELIST) {
            historyInsensitiveStyleWhitelistEls.add(Pair.pair(StringLiteral.valueOf(unk, propertyName.getCanonicalForm()), new BooleanLiteral(unk, true)));
        }
        ObjectConstructor objectConstructor = new ObjectConstructor(unk, members);
        ObjectConstructor alternateNames = new ObjectConstructor(unk, alternates);
        ObjectConstructor historyInsensitiveStyleWhitelist = new ObjectConstructor(unk, historyInsensitiveStyleWhitelistEls);
        ParseTreeNode js = QuasiBuilder.substV("var css = {  properties: (function () {    @constantPoolDecl?;    return @cssPropConstructor;  })(),  alternates: @alternates,  HISTORY_INSENSITIVE_STYLE_WHITELIST:       @historyInsensitiveStyleWhitelist};", "constantPoolDecl", constantPoolDecl, "cssPropConstructor", objectConstructor, "alternates", alternateNames, "historyInsensitiveStyleWhitelist", historyInsensitiveStyleWhitelist);
        TokenConsumer tc = js.makeRenderer(out, null);
        js.render(new RenderContext(tc));
        tc.consume(";");
        tc.noMoreTokens();
        out.append("\n");
    }

    static String propertyNameToDom2Property(Name cssPropertyName) {
        String lcaseDashed = cssPropertyName.getCanonicalForm();
        int dash = lcaseDashed.indexOf(45);
        if (dash < 0) {
            return lcaseDashed;
        }
        StringBuilder sb = new StringBuilder(lcaseDashed.length());
        int written = 0;
        do {
            sb.append(lcaseDashed, written, dash);
            written = dash + 1;
            if (written >= lcaseDashed.length()) continue;
            sb.append(Strings.toUpperCase(lcaseDashed.substring(written, written + 1)));
            ++written;
        } while ((dash = lcaseDashed.indexOf(45, written)) >= 0);
        sb.append(lcaseDashed, written, lcaseDashed.length());
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        CssSchema schema = CssSchema.getDefaultCss21Schema(new SimpleMessageQueue());
        CssPropertyPatterns.generatePatterns(schema, System.out);
    }

    static {
        String unsignedNum = "(?:\\d+(?:\\.\\d+)?)";
        String signedNum = "[+-]?\\d+(?:\\.\\d+)?";
        String angleUnits = "(?:deg|g?rad)";
        String freqUnits = "k?Hz";
        String lengthUnits = "(?:em|ex|px|in|cm|mm|pt|pc)";
        String timeUnits = "m?s";
        String quotedIdentifiers = "\"\\w(?:[\\w-]*\\w)(?:\\s+\\w([\\w-]*\\w))*\"";
        BUILTINS.put("number:0,", "0|" + unsignedNum);
        BUILTINS.put("number:0,1", "(?:0(?:\\.[0-9]+)?|\\.[0-9]+|1(?:\\.0+)?)");
        BUILTINS.put("number", "0|" + signedNum);
        BUILTINS.put("percentage", "0|" + unsignedNum + "%");
        BUILTINS.put("percentage:0,", "0|" + signedNum + "%");
        BUILTINS.put("angle:0,", "0|" + unsignedNum + angleUnits);
        BUILTINS.put("angle", "0|" + signedNum + angleUnits);
        BUILTINS.put("frequency", "0|" + unsignedNum + freqUnits);
        BUILTINS.put("length:0,", "0|" + unsignedNum + lengthUnits);
        BUILTINS.put("length", "0|" + signedNum + lengthUnits);
        BUILTINS.put("time:0,", "0|" + unsignedNum + timeUnits);
        BUILTINS.put("time", "0|" + signedNum + timeUnits);
        BUILTINS.put("integer", "-?\\d+");
        BUILTINS.put("integer:0,", "\\d+");
        BUILTINS.put("hex-color", "#(?:[0-9a-f]{3}){1,2}");
        BUILTINS.put("specific-voice", quotedIdentifiers);
        BUILTINS.put("family-name", quotedIdentifiers);
        BUILTINS.put("uri", "url\\(\"[^\\(\\)\\\\\\\"\\r\\n]+\"\\)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements BuildCommand {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean build(List<File> inputs, List<File> deps, File output) throws IOException {
            CssSchema schema;
            File symbolsAndPropertiesFile = null;
            File functionsFile = null;
            for (File input : inputs) {
                if (!input.getName().endsWith(".json")) continue;
                if (symbolsAndPropertiesFile == null) {
                    symbolsAndPropertiesFile = input;
                    continue;
                }
                if (functionsFile == null) {
                    functionsFile = input;
                    continue;
                }
                throw new IOException("Unused input " + input);
            }
            if (symbolsAndPropertiesFile == null) {
                throw new IOException("No JSON whitelist for CSS Symbols + Properties");
            }
            if (functionsFile == null) {
                throw new IOException("No JSON whitelist for CSS Functions");
            }
            FilePosition sps = FilePosition.startOfFile(new InputSource(symbolsAndPropertiesFile.getAbsoluteFile().toURI()));
            FilePosition fns = FilePosition.startOfFile(new InputSource(functionsFile.getAbsoluteFile().toURI()));
            MessageContext mc = new MessageContext();
            mc.addInputSource(sps.source());
            mc.addInputSource(fns.source());
            EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter((Writer)new OutputStreamWriter(System.err), true), mc, false);
            Set<File> inputsAndDeps = Sets.newHashSet();
            for (File f : inputs) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            for (File f : deps) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            AllowedFileResolver resolver = new AllowedFileResolver(inputsAndDeps);
            try {
                schema = new CssSchema(ConfigUtil.loadWhiteListFromJson(sps.source().getUri(), resolver, mq), ConfigUtil.loadWhiteListFromJson(fns.source().getUri(), resolver, mq));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
                throw (IOException)new IOException("Failed to parse schema").initCause(ex);
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8");
            String currentDate = "" + new Date();
            if (currentDate.indexOf("*/") >= 0) {
                throw new RuntimeException();
            }
            out.write("/* Copyright Google Inc.\n");
            out.write(" * Licensed under the Apache Licence Version 2.0\n");
            out.write(" * Autogenerated at " + currentDate + "\n");
            out.write(" * @provides css\n");
            out.write(" */\n");
            try {
                CssPropertyPatterns.generatePatterns(schema, out);
            }
            finally {
                ((Writer)out).close();
            }
            return true;
        }
    }

    private static final class Repetition
    implements Pattern {
        final Pattern repeated;
        final int min;
        final int max;

        Repetition(Pattern repeated, int min, int max) {
            this.repeated = repeated;
            this.min = min;
            this.max = max;
        }

        public Pattern optimize() {
            return new Repetition(this.repeated.optimize(), this.min, this.max);
        }

        public void render(StringBuilder out) {
            out.append("(?:");
            this.repeated.render(out);
            out.append(')');
            if (this.max == Integer.MAX_VALUE) {
                switch (this.min) {
                    case 0: {
                        out.append('*');
                        return;
                    }
                    case 1: {
                        out.append('+');
                        return;
                    }
                }
            } else if (this.max == 1 && this.min == 0) {
                out.append('?');
                return;
            }
            out.append('{').append(this.min).append(',').append(this.max).append('}');
        }

        public String tail() {
            return "";
        }

        public Pattern subtractTail(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Repetition)) {
                return false;
            }
            Repetition that = (Repetition)o;
            return this.min == that.min && this.max == that.max && this.repeated.equals(that.repeated);
        }

        public int hashCode() {
            return this.repeated.hashCode() + 31 * (this.min + 31 * this.max) ^ 0xA3C916;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Union
    implements Pattern {
        final List<Pattern> children;

        Union(List<Pattern> children) {
            this.children = children;
        }

        @Override
        public Pattern optimize() {
            ArrayList<Pattern> newChildren = new ArrayList<Pattern>();
            for (Pattern child : this.children) {
                if ((child = child.optimize()) instanceof Union) {
                    Union childUnion = (Union)child;
                    newChildren.addAll(childUnion.children);
                    continue;
                }
                newChildren.add(child);
            }
            int n = newChildren.size();
            if (n == 1) {
                return (Pattern)newChildren.get(0);
            }
            if (n != 0) {
                Pattern child0 = (Pattern)newChildren.get(0);
                String tail = child0.tail();
                for (Pattern child : newChildren.subList(1, n)) {
                    if ("".equals(tail)) break;
                    tail = CssPropertyPatterns.commonSuffix(tail, child.tail());
                }
                if (!"".equals(tail)) {
                    for (int i = 0; i < n; ++i) {
                        newChildren.set(i, ((Pattern)newChildren.get(i)).subtractTail(tail.length()));
                    }
                    Pattern opt = new Concatenation(Arrays.asList(new Union(newChildren), new Snippet(tail))).optimize();
                    return opt;
                }
            }
            Set seen = Sets.newHashSet();
            Iterator it = newChildren.iterator();
            while (it.hasNext()) {
                if (seen.add(it.next())) continue;
                it.remove();
            }
            if (n == 1) {
                return (Pattern)newChildren.get(0);
            }
            return new Union(newChildren);
        }

        @Override
        public void render(StringBuilder out) {
            out.append("(?:");
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    out.append('|');
                }
                this.children.get(i).render(out);
            }
            out.append(')');
        }

        @Override
        public String tail() {
            return "";
        }

        @Override
        public Pattern subtractTail(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Union)) {
                return false;
            }
            return ((Object)this.children).equals(((Union)o).children);
        }

        public int hashCode() {
            return ((Object)this.children).hashCode() ^ 0x11B79BED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Concatenation
    implements Pattern {
        final List<Pattern> children;

        Concatenation(List<Pattern> children) {
            this.children = children;
        }

        @Override
        public Pattern optimize() {
            ArrayList<Pattern> newChildren = new ArrayList<Pattern>();
            for (Pattern child : this.children) {
                if ((child = child.optimize()) instanceof Concatenation) {
                    Concatenation childCat = (Concatenation)child;
                    newChildren.addAll(childCat.children);
                    continue;
                }
                if (child instanceof Snippet && "".equals(((Snippet)child).patternSnippet)) continue;
                newChildren.add(child);
            }
            if (newChildren.size() == 1) {
                return (Pattern)newChildren.get(0);
            }
            return new Concatenation(newChildren);
        }

        @Override
        public void render(StringBuilder out) {
            for (Pattern n : this.children) {
                n.render(out);
            }
        }

        @Override
        public String tail() {
            return this.children.get(this.children.size() - 1).tail();
        }

        @Override
        public Pattern subtractTail(int n) {
            ArrayList<Pattern> newChildren = new ArrayList<Pattern>();
            int last = this.children.size() - 1;
            newChildren.addAll(this.children.subList(0, last));
            newChildren.add(this.children.get(last).subtractTail(n));
            return new Concatenation(newChildren);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Concatenation)) {
                return false;
            }
            return ((Object)this.children).equals(((Concatenation)o).children);
        }

        public int hashCode() {
            return ((Object)this.children).hashCode() ^ 0xD18B17E;
        }
    }

    private static final class Snippet
    implements Pattern {
        final String patternSnippet;

        Snippet(String patternSnippet) {
            this.patternSnippet = patternSnippet;
        }

        public Pattern optimize() {
            return this;
        }

        public void render(StringBuilder out) {
            out.append(this.patternSnippet);
        }

        public String tail() {
            return this.patternSnippet;
        }

        public Pattern subtractTail(int n) {
            return new Snippet(this.patternSnippet.substring(0, this.patternSnippet.length() - n));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Snippet)) {
                return false;
            }
            return this.patternSnippet.equals(((Snippet)o).patternSnippet);
        }

        public int hashCode() {
            return this.patternSnippet.hashCode() ^ 0x4482DE40;
        }
    }

    private static interface Pattern {
        public Pattern optimize();

        public void render(StringBuilder var1);

        public String tail();

        public Pattern subtractTail(int var1);
    }
}

