/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.util.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HtmlTextEscapingMode {
    PCDATA,
    CDATA,
    RCDATA,
    PLAIN_TEXT,
    VOID;

    private static final Map<String, HtmlTextEscapingMode> ESCAPING_MODES;

    public static HtmlTextEscapingMode getModeForTag(String canonTagName) {
        HtmlTextEscapingMode mode = ESCAPING_MODES.get(canonTagName);
        return mode != null ? mode : PCDATA;
    }

    public static boolean allowsEscapingTextSpan(String canonTagName) {
        return "style".equals(canonTagName) || "script".equals(canonTagName) || "title".equals(canonTagName) || "textarea".equals(canonTagName) || "noembed".equals(canonTagName) || "noscript".equals(canonTagName) || "noframes".equals(canonTagName);
    }

    public static boolean isTagFollowedByLiteralContent(String canonTagName) {
        HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(canonTagName);
        return mode != PCDATA && mode != VOID;
    }

    public static boolean isVoidElement(String canonTagName) {
        return HtmlTextEscapingMode.getModeForTag(canonTagName) == VOID;
    }

    static {
        ESCAPING_MODES = Maps.newHashMap();
        ESCAPING_MODES.put("iframe", CDATA);
        ESCAPING_MODES.put("noembed", CDATA);
        ESCAPING_MODES.put("noframes", CDATA);
        ESCAPING_MODES.put("noscript", CDATA);
        ESCAPING_MODES.put("plaintext", PLAIN_TEXT);
        ESCAPING_MODES.put("script", CDATA);
        ESCAPING_MODES.put("style", CDATA);
        ESCAPING_MODES.put("textarea", RCDATA);
        ESCAPING_MODES.put("title", RCDATA);
        ESCAPING_MODES.put("xmp", CDATA);
        ESCAPING_MODES.put("base", VOID);
        ESCAPING_MODES.put("link", VOID);
        ESCAPING_MODES.put("meta", VOID);
        ESCAPING_MODES.put("hr", VOID);
        ESCAPING_MODES.put("br", VOID);
        ESCAPING_MODES.put("img", VOID);
        ESCAPING_MODES.put("embed", VOID);
        ESCAPING_MODES.put("param", VOID);
        ESCAPING_MODES.put("area", VOID);
        ESCAPING_MODES.put("col", VOID);
        ESCAPING_MODES.put("input", VOID);
    }
}

