/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Keyword implements MessagePart
{
    ABSTRACT("abstract"),
    BOOLEAN("boolean"),
    BREAK("break"),
    BYTE("byte"),
    CASE("case"),
    CATCH("catch"),
    CHAR("char"),
    CLASS("class"),
    CONST("const"),
    CONTINUE("continue"),
    DEBUGGER("debugger"),
    DEFAULT("default"),
    DELETE("delete"),
    DO("do"),
    DOUBLE("double"),
    ELSE("else"),
    ENUM("enum"),
    EXPORT("export"),
    EXTENDS("extends"),
    FALSE("false"),
    FINAL("final"),
    FINALLY("finally"),
    FLOAT("float"),
    FOR("for"),
    FUNCTION("function"),
    GOTO("goto"),
    IF("if"),
    IMPLEMENTS("implements"),
    IMPORT("import"),
    IN("in"),
    INSTANCEOF("instanceof"),
    INT("int"),
    INTERFACE("interface"),
    LET("let"),
    LONG("long"),
    NATIVE("native"),
    NEW("new"),
    NULL("null"),
    OVERRIDE("override"),
    PACKAGE("package"),
    PRIVATE("private"),
    PROTECTED("protected"),
    PUBLIC("public"),
    RETURN("return"),
    SHORT("short"),
    STATIC("static"),
    SUPER("super"),
    SWITCH("switch"),
    SYNCHRONIZED("synchronized"),
    THIS("this"),
    THROW("throw"),
    THROWS("throws"),
    TRANSIENT("transient"),
    TRUE("true"),
    TRY("try"),
    TYPEOF("typeof"),
    USE("use"),
    VAR("var"),
    VOID("void"),
    VOLATILE("volatile"),
    WHILE("while"),
    WITH("with"),
    YIELD("yield");

    private final String keywordText;
    private static final Map<String, Keyword> JAVASCRIPT_KEYWORDS;

    private Keyword(String keywordText) {
        this.keywordText = keywordText;
    }

    @Override
    public void format(MessageContext mc, Appendable out) throws IOException {
        out.append(this.keywordText);
    }

    public String toString() {
        return this.keywordText;
    }

    public static Keyword fromString(String keywordText) {
        return JAVASCRIPT_KEYWORDS.get(keywordText);
    }

    public static boolean isKeyword(String name) {
        return JAVASCRIPT_KEYWORDS.containsKey(name);
    }

    static {
        JAVASCRIPT_KEYWORDS = new HashMap<String, Keyword>();
        for (Keyword k : Keyword.values()) {
            JAVASCRIPT_KEYWORDS.put(k.toString(), k);
        }
    }
}

