/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer.escaping;

import com.google.caja.lexer.escaping.Encoder;
import com.google.caja.lexer.escaping.EscapeMap;
import com.google.caja.util.SparseBitSet;
import java.io.IOException;

final class Escaper {
    private final CharSequence chars;
    private final EscapeMap precomputedEscapes;
    private final SparseBitSet otherEscapes;
    private final Encoder encoder;
    private final Appendable out;
    private final int minNonPrecomputed;

    Escaper(CharSequence chars, EscapeMap precomputedEscapes, SparseBitSet otherEscapes, Encoder encoder, Appendable out) {
        this.chars = chars;
        this.precomputedEscapes = precomputedEscapes;
        this.otherEscapes = otherEscapes;
        this.minNonPrecomputed = otherEscapes.isEmpty() ? 127 : otherEscapes.minSetBit();
        this.encoder = encoder;
        this.out = out;
    }

    void escape() throws IOException {
        int end = this.chars.length();
        if (end == 0) {
            return;
        }
        int pos = 0;
        if (this.otherEscapes.isEmpty()) {
            for (int i = 0; i < end; ++i) {
                if (!this.escapeOneChar(pos, i, this.chars.charAt(i))) continue;
                pos = i + 1;
            }
        } else {
            int codepoint = Character.codePointAt(this.chars, 0);
            int i = 0;
            while (i < end) {
                int nextCodepoint;
                int charCount = Character.charCount(codepoint);
                int i2 = i + charCount;
                int n = nextCodepoint = i2 < end ? Character.codePointAt(this.chars, i2) : -1;
                if (this.escapeOneCodepoint(pos, i, codepoint, nextCodepoint)) {
                    pos = i2;
                }
                i = i2;
                codepoint = nextCodepoint;
            }
        }
        this.out.append(this.chars, pos, end);
    }

    void normalize() throws IOException {
        int end = this.chars.length();
        if (end == 0) {
            return;
        }
        int pos = 0;
        int codepoint = Character.codePointAt(this.chars, 0);
        boolean escaped = false;
        int i = 0;
        while (i < end) {
            int nextCodepoint;
            int charCount = Character.charCount(codepoint);
            int i2 = i + charCount;
            int n = nextCodepoint = i2 < end ? Character.codePointAt(this.chars, i2) : -1;
            if (escaped) {
                escaped = false;
                if (this.escapeOneCodepoint(pos, i - 1, codepoint, nextCodepoint)) {
                    pos = i2;
                }
            } else if (codepoint == 92) {
                escaped = true;
            } else if (this.escapeOneCodepoint(pos, i, codepoint, nextCodepoint)) {
                pos = i2;
            }
            i = i2;
            codepoint = nextCodepoint;
        }
        this.out.append(this.chars, pos, end);
    }

    private boolean escapeOneChar(int pos, int limit, char ch) throws IOException {
        String esc = this.precomputedEscapes.getEscape(ch);
        if (esc != null) {
            this.out.append(this.chars, pos, limit).append(esc);
            return true;
        }
        return false;
    }

    private boolean escapeOneCodepoint(int pos, int limit, int codepoint, int nextCodepoint) throws IOException {
        if (codepoint < this.minNonPrecomputed) {
            String esc = this.precomputedEscapes.getEscape(codepoint);
            if (esc != null) {
                this.out.append(this.chars, pos, limit).append(esc);
                return true;
            }
        } else if (this.otherEscapes.contains(codepoint)) {
            this.out.append(this.chars, pos, limit);
            this.encoder.encode(codepoint, nextCodepoint, this.out);
            return true;
        }
        return false;
    }
}

