/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LookaheadLexer
implements TokenStream<HtmlTokenType> {
    private final TokenStream<HtmlTokenType> lexer;
    private List<Token<HtmlTokenType>> pending = new LinkedList<Token<HtmlTokenType>>();

    LookaheadLexer(TokenStream<HtmlTokenType> lexer) {
        this.lexer = lexer;
    }

    @Override
    public boolean hasNext() throws ParseException {
        return !this.pending.isEmpty() || this.lexer.hasNext();
    }

    @Override
    public Token<HtmlTokenType> next() throws ParseException {
        return this.pending.isEmpty() ? this.lexer.next() : this.pending.remove(0);
    }

    Token<HtmlTokenType> peek() throws ParseException {
        if (this.pending.isEmpty()) {
            if (!this.lexer.hasNext()) {
                return null;
            }
            Token<HtmlTokenType> next = this.lexer.next();
            this.pending.add(next);
            return next;
        }
        return this.pending.get(this.pending.size() - 1);
    }

    void pushBack(Token<HtmlTokenType> t) {
        this.pending.add(0, t);
    }
}

