/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Punctuation;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Associativity;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CaseStmt;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.DebuggerStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DefaultCaseStmt;
import com.google.caja.parser.js.Directive;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.DoWhileLoop;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FinallyStmt;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.ForLoop;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.OperatorType;
import com.google.caja.parser.js.RealLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SwitchCase;
import com.google.caja.parser.js.SwitchStmt;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.js.WhileLoop;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parser
extends ParserBase {
    private boolean recoverFromFailure;

    public Parser(JsTokenQueue tq, MessageQueue mq) {
        this(tq, mq, false);
    }

    public Parser(JsTokenQueue tq, MessageQueue mq, boolean isQuasiliteral) {
        super(tq, mq, isQuasiliteral);
    }

    public boolean getRecoverFromFailure() {
        return this.recoverFromFailure;
    }

    public void setRecoverFromFailure(boolean shouldRecover) {
        this.recoverFromFailure = shouldRecover;
    }

    public Block parse() throws ParseException {
        Block program = this.parseProgramOrFunctionBody();
        this.tq.expectEmpty();
        return program;
    }

    public Statement parseStatement() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        Token t = this.tq.peek();
        if (JsTokenType.WORD == t.type) {
            String label = this.parseIdentifier(false);
            FilePosition labelPos = t.pos;
            if (this.tq.checkToken(Punctuation.COLON)) {
                t = this.tq.peek();
                LabeledStatement s = null;
                if (JsTokenType.KEYWORD == t.type) {
                    switch (Keyword.fromString(t.text)) {
                        case FOR: 
                        case DO: 
                        case WHILE: 
                        case SWITCH: {
                            s = this.parseLoopOrSwitch(labelPos, label);
                            break;
                        }
                    }
                }
                if (null == s) {
                    AbstractStatement labelless = this.parseStatementWithoutLabel();
                    s = new LabeledStmtWrapper(this.posFrom(m), label, labelless);
                }
                this.finish(s, m);
                return s;
            }
            this.tq.rewind(m);
        }
        return this.parseStatementWithoutLabel();
    }

    private Block parseProgramOrFunctionBody() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        DirectivePrologue prologue = this.parseOptionalDirectivePrologue();
        if (prologue != null) {
            stmts.add(prologue);
        }
        while (!this.tq.isEmpty() && !this.tq.lookaheadToken(Punctuation.RCURLY)) {
            stmts.add(this.parseTerminatedStatement());
        }
        Block b = new Block(this.posFrom(m), stmts);
        this.finish(b, m);
        return b;
    }

    private DirectivePrologue parseOptionalDirectivePrologue() throws ParseException {
        if (this.tq.isEmpty() || this.tq.peek().type != JsTokenType.STRING) {
            return null;
        }
        TokenQueue.Mark startOfPrologue = this.tq.mark();
        List<Directive> directives = Lists.newArrayList();
        while (!this.tq.isEmpty() && this.tq.peek().type == JsTokenType.STRING) {
            String decoded;
            String unquoted;
            TokenQueue.Mark startOfDirective = this.tq.mark();
            Token quotedString = this.tq.pop();
            if (!this.tq.checkToken(Punctuation.SEMI)) {
                Token t;
                Token token = t = !this.tq.isEmpty() ? this.tq.peek() : null;
                if ((t == null || !Parser.continuesExpr(t.text)) && this.semicolonInserted()) {
                    FilePosition semiPoint = FilePosition.endOf(this.tq.lastPosition());
                    MessageLevel lvl = this.tq.isEmpty() || this.tq.lookaheadToken(Punctuation.RCURLY) ? MessageLevel.LOG : MessageLevel.LINT;
                    this.mq.addMessage((MessageTypeInt)MessageType.SEMICOLON_INSERTED, lvl, semiPoint);
                } else {
                    this.tq.rewind(startOfDirective);
                    break;
                }
            }
            if (!(unquoted = quotedString.text.substring(1, quotedString.text.length() - 1)).equals(decoded = StringLiteral.getUnquotedValueOf(quotedString.text)) || !Directive.RecognizedValue.isDirectiveStringRecognized(unquoted)) {
                this.mq.addMessage((MessageTypeInt)MessageType.UNRECOGNIZED_DIRECTIVE_IN_PROLOGUE, quotedString.pos, MessagePart.Factory.valueOf(decoded));
            }
            Directive d = new Directive(this.posFrom(quotedString.pos), decoded);
            this.finish(d, startOfDirective);
            directives.add(d);
        }
        if (directives.isEmpty()) {
            return null;
        }
        DirectivePrologue prologue = new DirectivePrologue(this.posFrom(startOfPrologue), directives);
        this.finish(prologue, startOfPrologue);
        return prologue;
    }

    private static boolean continuesExpr(String tokenText) {
        return Operator.lookupOperation(tokenText, OperatorType.INFIX) != null || Operator.lookupOperation(tokenText, OperatorType.BRACKET) != null || Operator.lookupOperation(tokenText, OperatorType.TERNARY) != null;
    }

    private LabeledStatement parseLoopOrSwitch(FilePosition start, String label) throws ParseException {
        LabeledStatement s;
        Token t = this.tq.peek();
        switch (Keyword.fromString(t.text)) {
            case FOR: {
                AbstractStatement increment;
                this.tq.advance();
                this.tq.expectToken(Punctuation.LPAREN);
                if (this.tq.checkToken(Punctuation.SEMI)) {
                    AbstractStatement increment2;
                    Noop initializer = Parser.noop(this.tq.lastPosition());
                    Expression condition = this.parseExpressionOrNoop(new BooleanLiteral(FilePosition.startOf(this.tq.currentPosition()), true), true);
                    if (!this.tq.checkToken(Punctuation.RPAREN)) {
                        increment2 = this.parseExpressionStmt(true);
                        this.tq.expectToken(Punctuation.RPAREN);
                    } else {
                        increment2 = Parser.noop(this.tq.lastPosition());
                    }
                    Statement body = this.parseBody(true);
                    s = new ForLoop(this.posFrom(start), label, initializer, condition, increment2, body);
                    break;
                }
                AbstractStatement initializer = this.parseDeclarationsOrExpression(true);
                Operation initializerExpr = null;
                if (initializer instanceof Declaration && null == ((Declaration)initializer).getInitializer() && this.tq.checkToken(Keyword.IN) || !this.tq.lookaheadToken(Punctuation.SEMI) && (initializerExpr = Parser.checkInExprWithLhs(initializer)) != null) {
                    Expression lvalue;
                    Expression iterable;
                    if (null == initializerExpr) {
                        iterable = this.parseExpressionInt(true);
                        lvalue = null;
                    } else {
                        Operation op = initializerExpr;
                        lvalue = op.children().get(0);
                        iterable = op.children().get(1);
                    }
                    this.tq.expectToken(Punctuation.RPAREN);
                    Statement body = this.parseBody(true);
                    if (null == lvalue) {
                        s = new ForEachLoop(this.posFrom(start), label, (Declaration)initializer, iterable, body);
                        break;
                    }
                    s = new ForEachLoop(this.posFrom(start), label, lvalue, iterable, body);
                    break;
                }
                TokenQueue.Mark m = this.tq.mark();
                this.tq.expectToken(Punctuation.SEMI);
                Expression condition = this.parseExpressionOrNoop(new BooleanLiteral(this.posFrom(m), true), true);
                if (!this.tq.checkToken(Punctuation.RPAREN)) {
                    increment = this.parseExpressionStmt(true);
                    this.tq.expectToken(Punctuation.RPAREN);
                } else {
                    increment = Parser.noop(this.tq.lastPosition());
                }
                Statement body = this.parseBody(true);
                s = new ForLoop(this.posFrom(start), label, initializer, condition, increment, body);
                break;
            }
            case WHILE: {
                this.tq.advance();
                this.tq.expectToken(Punctuation.LPAREN);
                AbstractExpression cond = this.parseExpressionInt(true);
                this.tq.expectToken(Punctuation.RPAREN);
                Statement body = this.parseBody(true);
                s = new WhileLoop(this.posFrom(start), label, cond, body);
                break;
            }
            case DO: {
                this.tq.advance();
                Statement body = this.parseBody(false);
                this.tq.expectToken(Keyword.WHILE);
                this.tq.expectToken(Punctuation.LPAREN);
                AbstractExpression cond = this.parseExpressionInt(true);
                this.tq.expectToken(Punctuation.RPAREN);
                s = new DoWhileLoop(this.posFrom(start), label, body, cond);
                break;
            }
            case SWITCH: {
                this.tq.advance();
                this.tq.expectToken(Punctuation.LPAREN);
                AbstractExpression switchValue = this.parseExpressionInt(true);
                this.tq.expectToken(Punctuation.RPAREN);
                this.tq.expectToken(Punctuation.LCURLY);
                ArrayList<SwitchCase> cases = new ArrayList<SwitchCase>();
                while (!this.tq.checkToken(Punctuation.RCURLY)) {
                    Statement caseBody;
                    AbstractExpression caseValue;
                    TokenQueue.Mark caseMark = this.tq.mark();
                    if (this.tq.checkToken(Keyword.DEFAULT)) {
                        caseValue = null;
                    } else {
                        this.tq.expectToken(Keyword.CASE);
                        caseValue = this.parseExpressionInt(false);
                    }
                    this.tq.expectToken(Punctuation.COLON);
                    FilePosition colonPos = this.tq.lastPosition();
                    TokenQueue.Mark caseBodyStart = this.tq.mark();
                    ArrayList<Statement> caseBodyContents = new ArrayList<Statement>();
                    while (!(this.tq.lookaheadToken(Keyword.DEFAULT) || this.tq.lookaheadToken(Keyword.CASE) || this.tq.lookaheadToken(Punctuation.RCURLY))) {
                        caseBodyContents.add(this.parseTerminatedStatement());
                    }
                    switch (caseBodyContents.size()) {
                        case 0: {
                            caseBody = Parser.noop(FilePosition.endOf(colonPos));
                            break;
                        }
                        case 1: {
                            caseBody = (Statement)caseBodyContents.get(0);
                            break;
                        }
                        default: {
                            caseBody = new Block(this.posFrom(caseBodyStart), caseBodyContents);
                            this.finish((AbstractParseTreeNode)((Object)caseBody), caseBodyStart);
                        }
                    }
                    SwitchCase caseStmt = null != caseValue ? new CaseStmt(this.posFrom(caseMark), caseValue, caseBody) : new DefaultCaseStmt(this.posFrom(caseMark), caseBody);
                    this.finish(caseStmt, caseMark);
                    cases.add(caseStmt);
                }
                s = new SwitchStmt(this.posFrom(start), label, switchValue, cases);
                break;
            }
            default: {
                throw new AssertionError((Object)t.text);
            }
        }
        return s;
    }

    private AbstractStatement parseStatementWithoutLabel() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        Token t = this.tq.peek();
        if (JsTokenType.KEYWORD == t.type) {
            AbstractStatement s;
            switch (Keyword.fromString(t.text)) {
                case FOR: 
                case DO: 
                case WHILE: 
                case SWITCH: {
                    s = this.parseLoopOrSwitch(t.pos, "");
                    break;
                }
                case IF: {
                    boolean sawElse;
                    this.tq.advance();
                    ArrayList<Pair<Expression, Statement>> clauses = new ArrayList<Pair<Expression, Statement>>();
                    Statement elseClause = null;
                    do {
                        this.tq.expectToken(Punctuation.LPAREN);
                        AbstractExpression cond = this.parseExpressionInt(true);
                        this.tq.expectToken(Punctuation.RPAREN);
                        Statement body = this.parseBody(false);
                        sawElse = this.tq.checkToken(Keyword.ELSE);
                        clauses.add(new Pair<AbstractExpression, Statement>(cond, body));
                    } while (sawElse && this.tq.checkToken(Keyword.IF));
                    if (sawElse) {
                        elseClause = this.parseBody(true);
                    }
                    s = new Conditional(this.posFrom(m), clauses, elseClause);
                    break;
                }
                case VAR: 
                case CONST: {
                    return this.parseDeclarationsOrExpression(false);
                }
                case FUNCTION: {
                    TokenQueue.Mark fs = this.tq.mark();
                    this.tq.advance();
                    if (this.tq.lookaheadToken(Punctuation.LPAREN)) {
                        this.tq.rewind(fs);
                        return this.parseExpressionStmt(false);
                    }
                    Identifier identifier = this.parseIdentifierNode(false);
                    this.tq.expectToken(Punctuation.LPAREN);
                    FormalParamList params = this.parseFormalParams();
                    this.tq.expectToken(Punctuation.RPAREN);
                    this.tq.expectToken(Punctuation.LCURLY);
                    Block body = this.parseProgramOrFunctionBody();
                    this.tq.expectToken(Punctuation.RCURLY);
                    FunctionConstructor fc = new FunctionConstructor(this.posFrom(m), identifier, params.params, body);
                    this.finish(fc, m);
                    s = new FunctionDeclaration(fc);
                    this.finish(s, m);
                    break;
                }
                case RETURN: {
                    this.tq.advance();
                    AbstractExpression value = this.semicolonInserted() || this.tq.lookaheadToken(Punctuation.SEMI) ? null : this.parseExpressionInt(false);
                    s = new ReturnStmt(this.posFrom(m), value);
                    break;
                }
                case BREAK: {
                    this.tq.advance();
                    String targetLabel = "";
                    if (!this.semicolonInserted() && JsTokenType.WORD == this.tq.peek().type) {
                        targetLabel = this.parseIdentifier(false);
                    }
                    s = new BreakStmt(this.posFrom(m), targetLabel);
                    break;
                }
                case CONTINUE: {
                    this.tq.advance();
                    String targetLabel = "";
                    if (!this.semicolonInserted() && JsTokenType.WORD == this.tq.peek().type) {
                        targetLabel = this.parseIdentifier(false);
                    }
                    s = new ContinueStmt(this.posFrom(m), targetLabel);
                    break;
                }
                case DEBUGGER: {
                    this.tq.advance();
                    s = new DebuggerStmt(this.posFrom(m));
                    break;
                }
                case THROW: {
                    this.tq.advance();
                    if (this.semicolonInserted()) {
                        throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, FilePosition.endOf(this.tq.lastPosition()), MessagePart.Factory.valueOf("<expression>"), MessagePart.Factory.valueOf("<newline>")));
                    }
                    AbstractExpression ex = this.parseExpressionInt(false);
                    s = new ThrowStmt(this.posFrom(m), ex);
                    break;
                }
                case TRY: {
                    FinallyStmt finallyBlock;
                    CatchStmt handler;
                    this.tq.advance();
                    Block body = this.parseBodyBlock();
                    TokenQueue.Mark m2 = this.tq.mark();
                    boolean sawFinally = this.tq.checkToken(Keyword.FINALLY);
                    if (sawFinally) {
                        handler = null;
                    } else {
                        this.tq.expectToken(Keyword.CATCH);
                        this.tq.expectToken(Punctuation.LPAREN);
                        Identifier idNode = this.parseIdentifierNode(false);
                        Declaration exvar = new Declaration(idNode.getFilePosition(), idNode, (Expression)null);
                        exvar.setComments(idNode.getComments());
                        this.tq.expectToken(Punctuation.RPAREN);
                        Block catchBody = this.parseBodyBlock();
                        handler = new CatchStmt(this.posFrom(m2), exvar, catchBody);
                        this.finish(handler, m2);
                        m2 = this.tq.mark();
                        sawFinally = this.tq.checkToken(Keyword.FINALLY);
                    }
                    if (sawFinally) {
                        Block st = this.parseBodyBlock();
                        finallyBlock = new FinallyStmt(this.posFrom(m2), st);
                        this.finish(finallyBlock, m2);
                    } else {
                        finallyBlock = null;
                    }
                    s = new TryStmt(this.posFrom(m), body, handler, finallyBlock);
                    break;
                }
                case WITH: {
                    this.tq.advance();
                    this.tq.expectToken(Punctuation.LPAREN);
                    AbstractExpression scopeObject = this.parseExpressionInt(true);
                    this.tq.expectToken(Punctuation.RPAREN);
                    Statement body = this.parseBody(true);
                    s = new WithStmt(this.posFrom(m), scopeObject, body);
                    break;
                }
                default: {
                    return this.parseExpressionStmt(false);
                }
            }
            this.finish(s, m);
            return s;
        }
        if (this.tq.checkToken(Punctuation.LCURLY)) {
            ArrayList<Statement> blockParts = new ArrayList<Statement>();
            while (!this.tq.checkToken(Punctuation.RCURLY)) {
                blockParts.add(this.parseTerminatedStatement());
            }
            Block b = new Block(this.posFrom(m), blockParts);
            this.finish(b, m);
            return b;
        }
        if (this.tq.checkToken(Punctuation.SEMI)) {
            return Parser.noop(this.tq.lastPosition());
        }
        return this.parseExpressionStmt(false);
    }

    public Expression parseExpression(boolean insertionProtected) throws ParseException {
        return this.parseExpressionInt(insertionProtected);
    }

    private AbstractExpression parseExpressionInt(boolean insertionProtected) throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        AbstractExpression e = this.parseOp(Integer.MAX_VALUE, insertionProtected);
        while (this.tq.checkToken(Punctuation.COMMA)) {
            Expression right = this.parseExpressionPart(insertionProtected);
            e = Operation.create(this.posFrom(m), Operator.COMMA, e, right);
            this.finish(e, m);
        }
        return e;
    }

    public Expression parseExpressionPart(boolean insertionProtected) throws ParseException {
        return this.parseOp(Integer.MAX_VALUE, insertionProtected);
    }

    private AbstractExpression parseOp(int precedence, boolean insertionProtected) throws ParseException {
        AbstractExpression left = null;
        Token t = this.tq.peek();
        Operator op = Operator.lookupOperation(t.text, OperatorType.PREFIX);
        if (null != op) {
            TokenQueue.Mark m = this.tq.mark();
            this.tq.advance();
            int opprec = op.getPrecedence();
            if (opprec >= precedence) {
                throw new ParseException(new Message((MessageTypeInt)MessageType.UNEXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(t.text)));
            }
            left = this.parseOp(opprec + 1, insertionProtected);
            try {
                left = Operation.create(this.posFrom(m), op, left);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(new Message((MessageTypeInt)MessageType.ASSIGN_TO_NON_LVALUE, t.pos, MessagePart.Factory.valueOf(t.text)));
            }
            this.finish(left, m);
        }
        if (null == left) {
            left = this.parseExpressionAtom();
        }
        block10: while (!this.tq.isEmpty()) {
            Expression right;
            Object actuals;
            int opprec;
            t = this.tq.peek();
            op = Operator.lookupOperation(t.text, OperatorType.INFIX);
            if (null == op) {
                op = Operator.lookupOperation(t.text, OperatorType.BRACKET);
                if (null == op && null == (op = Operator.lookupOperation(t.text, OperatorType.TERNARY))) {
                    if (!this.semicolonInserted()) {
                        op = Operator.lookupOperation(t.text, OperatorType.POSTFIX);
                    }
                    if (null == op) {
                        break;
                    }
                }
            } else if (Operator.COMMA == op) break;
            if ((opprec = op.getPrecedence()) >= precedence && (opprec != precedence || Associativity.RIGHT != op.getAssociativity())) break;
            TokenQueue.Mark opStart = this.tq.mark();
            int nMessages = this.mq.getMessages().size();
            this.tq.advance();
            try {
                if (OperatorType.BRACKET == op.getType()) {
                    if (Operator.FUNCTION_CALL == op) {
                        if (this.tq.checkToken(op.getClosingSymbol())) {
                            actuals = Collections.emptyList();
                        } else {
                            actuals = new ArrayList();
                            do {
                                actuals.add((Expression)this.parseExpressionPart(true));
                            } while (this.tq.checkToken(Punctuation.COMMA));
                            this.tq.expectToken(op.getClosingSymbol());
                        }
                        right = new ActualList((List<Expression>)actuals);
                    } else {
                        right = this.parseExpressionInt(true);
                        this.tq.expectToken(op.getClosingSymbol());
                    }
                } else {
                    right = OperatorType.POSTFIX == op.getType() ? null : (OperatorType.TERNARY == op.getType() ? this.parseExpressionPart(insertionProtected) : (Operator.MEMBER_ACCESS != op ? this.parseOp(opprec, insertionProtected) : this.parseReference(true)));
                }
            }
            catch (ParseException ex) {
                if (!(Operator.FUNCTION_CALL != op && null == Operator.lookupOperation(op.getOpeningSymbol(), OperatorType.PREFIX) || insertionProtected)) {
                    TokenQueue.Mark m3 = this.tq.mark();
                    this.tq.rewind(opStart);
                    if (this.semicolonInserted()) {
                        List<Message> messages = this.mq.getMessages();
                        if (nMessages < messages.size()) {
                            messages.subList(nMessages, messages.size()).clear();
                        }
                        FilePosition semiPoint = FilePosition.endOf(this.tq.lastPosition());
                        messages.add(new Message((MessageTypeInt)MessageType.SEMICOLON_INSERTED, semiPoint));
                        return left;
                    }
                    this.tq.rewind(m3);
                }
                throw ex;
            }
            switch (op.getType()) {
                case TERNARY: {
                    this.tq.expectToken(op.getClosingSymbol());
                    Expression farRight = this.parseExpressionPart(insertionProtected);
                    left = Operation.create(this.posFrom(left), op, left, right, farRight);
                    continue block10;
                }
                case BRACKET: {
                    if (Operator.FUNCTION_CALL == op) {
                        actuals = (ActualList)right;
                        List<? extends Expression> params = ((ActualList)actuals).children();
                        Expression[] operands = new Expression[params.size() + 1];
                        operands[0] = left;
                        for (int i = 1; i < operands.length; ++i) {
                            operands[i] = params.get(i - 1);
                        }
                        left = Operation.create(this.posFrom(left), op, operands);
                        continue block10;
                    }
                    left = Operation.create(this.posFrom(left), op, left, right);
                    continue block10;
                }
                case INFIX: {
                    if (op.getCategory() == OperatorCategory.ASSIGNMENT && !left.isLeftHandSide()) {
                        throw new ParseException(new Message((MessageTypeInt)MessageType.ASSIGN_TO_NON_LVALUE, t.pos, MessagePart.Factory.valueOf(t.text)));
                    }
                    left = Operation.create(this.posFrom(left), op, left, right);
                    continue block10;
                }
                case POSTFIX: {
                    if (op.getCategory() == OperatorCategory.ASSIGNMENT && !left.isLeftHandSide()) {
                        throw new ParseException(new Message((MessageTypeInt)MessageType.ASSIGN_TO_NON_LVALUE, t.pos, MessagePart.Factory.valueOf(t.text)));
                    }
                    left = Operation.create(this.posFrom(left), op, left);
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        return left;
    }

    private boolean semicolonInserted() throws ParseException {
        if (this.tq.isEmpty() || this.tq.lookaheadToken(Punctuation.RCURLY)) {
            return true;
        }
        FilePosition last = this.tq.lastPosition();
        FilePosition current = this.tq.currentPosition();
        if (last == null) {
            return true;
        }
        if (current.startLineNo() == last.endLineNo()) {
            return false;
        }
        for (Token filtered : this.tq.filteredTokens()) {
            if (filtered.type != JsTokenType.LINE_CONTINUATION) continue;
            return false;
        }
        return true;
    }

    private double toNumber(Token<JsTokenType> t) {
        return Double.parseDouble(t.text);
    }

    private String floatToString(Token<JsTokenType> t) {
        return NumberLiteral.numberToString(new BigDecimal(t.text));
    }

    private NumberLiteral toNumberLiteral(Token<JsTokenType> t) {
        return new RealLiteral(t.pos, this.toNumber(t));
    }

    private strictfp long toInteger(Token<JsTokenType> t) {
        Long longValue = Long.decode(t.text);
        long lv = longValue;
        if (0L != ((lv < 0L ? lv ^ 0xFFFFFFFFFFFFFFFFL : lv) & 0xFFF8000000000000L)) {
            this.mq.addMessage((MessageTypeInt)MessageType.UNREPRESENTABLE_INTEGER_LITERAL, t.pos, MessagePart.Factory.valueOf(t.text));
            double dv = lv;
            return (long)dv;
        }
        return lv;
    }

    private NumberLiteral toIntegerLiteral(Token<JsTokenType> t) {
        Long longValue = Long.decode(t.text);
        long lv = longValue;
        if (0L != ((lv < 0L ? lv ^ 0xFFFFFFFFFFFFFFFFL : lv) & 0xFFF8000000000000L)) {
            this.mq.addMessage((MessageTypeInt)MessageType.UNREPRESENTABLE_INTEGER_LITERAL, t.pos, MessagePart.Factory.valueOf(t.text));
            return new RealLiteral(t.pos, lv);
        }
        return new IntegerLiteral(t.pos, lv);
    }

    private AbstractExpression parseExpressionAtom() throws ParseException {
        AbstractExpression e2;
        TokenQueue.Mark m = this.tq.mark();
        Token<JsTokenType> t = this.tq.pop();
        block0 : switch ((JsTokenType)t.type) {
            case STRING: {
                Parser.issueLintWarningsForProblematicEscapes(t, this.mq);
                e2 = new StringLiteral(t.pos, t.text);
                break;
            }
            case INTEGER: {
                if (Parser.integerPartIsOctal(t.text)) {
                    this.mq.addMessage((MessageTypeInt)MessageType.OCTAL_LITERAL, MessageLevel.LINT, t.pos, MessagePart.Factory.valueOf(t.text));
                }
                e2 = this.toIntegerLiteral(t);
                break;
            }
            case FLOAT: {
                if (Parser.integerPartIsOctal(t.text)) {
                    this.mq.addMessage((MessageTypeInt)MessageType.OCTAL_LITERAL, MessageLevel.ERROR, t.pos, MessagePart.Factory.valueOf(t.text));
                }
                e2 = this.toNumberLiteral(t);
                break;
            }
            case REGEXP: {
                e2 = new RegexpLiteral(t.pos, t.text);
                String modifiers = t.text.substring(t.text.lastIndexOf("/") + 1);
                if (RegexpLiteral.areRegexpModifiersValid(modifiers)) break;
                this.mq.addMessage((MessageTypeInt)MessageType.UNRECOGNIZED_REGEX_MODIFIERS, t.pos, MessagePart.Factory.valueOf(modifiers));
                break;
            }
            case KEYWORD: {
                Keyword k = Keyword.fromString(t.text);
                if (null != k) {
                    switch (k) {
                        case NULL: {
                            e2 = new NullLiteral(t.pos);
                            break block0;
                        }
                        case TRUE: {
                            e2 = new BooleanLiteral(t.pos, true);
                            break block0;
                        }
                        case FALSE: {
                            e2 = new BooleanLiteral(t.pos, false);
                            break block0;
                        }
                        case FUNCTION: {
                            Identifier identifier = null;
                            identifier = !this.tq.isEmpty() && JsTokenType.WORD == this.tq.peek().type ? this.parseIdentifierNode(false) : new Identifier(FilePosition.endOf(this.tq.lastPosition()), null);
                            this.tq.expectToken(Punctuation.LPAREN);
                            FormalParamList params = this.parseFormalParams();
                            this.tq.expectToken(Punctuation.RPAREN);
                            this.tq.expectToken(Punctuation.LCURLY);
                            Block body = this.parseProgramOrFunctionBody();
                            this.tq.expectToken(Punctuation.RCURLY);
                            e2 = new FunctionConstructor(this.posFrom(m), identifier, params.params, body);
                            break block0;
                        }
                    }
                }
            }
            case WORD: {
                String identifier;
                if (Keyword.THIS.toString().equals(t.text)) {
                    identifier = Keyword.THIS.toString();
                } else {
                    this.tq.rewind(m);
                    identifier = this.parseIdentifier(false);
                }
                Identifier idNode = new Identifier(this.posFrom(m), identifier);
                this.finish(idNode, m);
                e2 = new Reference(idNode);
                break;
            }
            case PUNCTUATION: {
                switch (Punctuation.fromString(t.text)) {
                    case LPAREN: {
                        AbstractExpression e2 = this.parseExpressionInt(true);
                        this.tq.expectToken(Punctuation.RPAREN);
                        return e2;
                    }
                    case LSQUARE: {
                        ArrayList<Expression> elements = new ArrayList<Expression>();
                        boolean empty = true;
                        while (!this.tq.checkToken(Punctuation.RSQUARE)) {
                            boolean lastComma = false;
                            TokenQueue.Mark cm = this.tq.mark();
                            while (this.tq.checkToken(Punctuation.COMMA)) {
                                if (empty) {
                                    Operation vl = Operation.undefined(this.posFrom(cm));
                                    this.finish(vl, cm);
                                    elements.add(vl);
                                } else {
                                    empty = true;
                                }
                                lastComma = true;
                                cm = this.tq.mark();
                            }
                            if (!this.tq.checkToken(Punctuation.RSQUARE)) {
                                elements.add(this.parseExpressionPart(true));
                                lastComma = false;
                                empty = false;
                                continue;
                            }
                            if (!lastComma) break;
                            this.mq.addMessage((MessageTypeInt)MessageType.NOT_IE, cm.getFilePosition());
                            break;
                        }
                        e2 = new ArrayConstructor(this.posFrom(m), elements);
                        break block0;
                    }
                    case LCURLY: {
                        ArrayList<Pair<Literal, Expression>> properties = new ArrayList<Pair<Literal, Expression>>();
                        if (!this.tq.checkToken(Punctuation.RCURLY)) {
                            boolean sawComma;
                            do {
                                StringLiteral key;
                                TokenQueue.Mark km = this.tq.mark();
                                Token<JsTokenType> keyToken = this.tq.peek();
                                switch ((JsTokenType)keyToken.type) {
                                    case STRING: {
                                        this.tq.advance();
                                        key = new StringLiteral(this.posFrom(km), keyToken.text);
                                        break;
                                    }
                                    case FLOAT: {
                                        this.tq.advance();
                                        key = StringLiteral.valueOf(this.posFrom(km), this.floatToString(keyToken));
                                        break;
                                    }
                                    case INTEGER: {
                                        this.tq.advance();
                                        key = StringLiteral.valueOf(this.posFrom(km), "" + this.toInteger(keyToken));
                                        break;
                                    }
                                    default: {
                                        String ident = this.parseIdentifier(true);
                                        key = StringLiteral.valueOf(this.posFrom(km), ident);
                                    }
                                }
                                this.finish(key, km);
                                this.tq.expectToken(Punctuation.COLON);
                                Expression value = this.parseExpressionPart(true);
                                properties.add(Pair.pair(key, value));
                                TokenQueue.Mark cm = this.tq.mark();
                                sawComma = this.tq.checkToken(Punctuation.COMMA);
                                if (!sawComma || !this.tq.lookaheadToken(Punctuation.RCURLY)) continue;
                                this.tq.rewind(cm);
                                this.mq.addMessage((MessageTypeInt)MessageType.NOT_IE, this.tq.currentPosition());
                                this.tq.advance();
                                break;
                            } while (sawComma);
                            this.tq.expectToken(Punctuation.RCURLY);
                        }
                        e2 = new ObjectConstructor(this.posFrom(m), properties);
                        break block0;
                    }
                }
                e2 = null;
                break;
            }
            default: {
                e2 = null;
            }
        }
        if (null == e2) {
            if (this.recoverFromFailure) {
                this.tq.rewind(m);
                FilePosition pos = FilePosition.span(this.tq.lastPosition(), this.tq.currentPosition());
                this.mq.addMessage((MessageTypeInt)MessageType.PLACEHOLDER_INSERTED, pos);
                Identifier idNode = new Identifier(pos, "_");
                e2 = new Reference(idNode);
            } else {
                throw new ParseException(new Message((MessageTypeInt)MessageType.UNEXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(t.text)));
            }
        }
        this.finish(e2, m);
        return e2;
    }

    private Reference parseReference(boolean allowReservedWords) throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        Identifier idNode = this.parseIdentifierNode(allowReservedWords);
        Reference r = new Reference(idNode);
        this.finish(r, m);
        return r;
    }

    private Identifier parseIdentifierNode(boolean allowReservedWords) throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        String identifierName = this.parseIdentifier(allowReservedWords);
        Identifier ident = new Identifier(this.posFrom(m), identifierName);
        this.finish(ident, m);
        return ident;
    }

    private ExpressionStmt parseExpressionStmt(boolean insertionProtected) throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        AbstractExpression e = this.parseExpressionInt(insertionProtected);
        ExpressionStmt es = new ExpressionStmt(this.posFrom(m), e);
        this.finish(es, m);
        return es;
    }

    private Expression parseExpressionOrNoop(AbstractExpression def, boolean insertionProtected) throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        if (this.tq.checkToken(Punctuation.SEMI)) {
            this.finish(def, m);
            return def;
        }
        AbstractExpression e = this.parseExpressionInt(insertionProtected);
        this.tq.expectToken(Punctuation.SEMI);
        return e;
    }

    private static boolean isTerminal(Statement s) {
        if (s instanceof LabeledStmtWrapper) {
            return Parser.isTerminal(((LabeledStmtWrapper)s).getBody());
        }
        return s instanceof Loop && !(s instanceof DoWhileLoop) || s instanceof Conditional || s instanceof FunctionDeclaration || s instanceof Block || s instanceof TryStmt || s instanceof ForEachLoop || s instanceof SwitchStmt || s instanceof Noop || s instanceof WithStmt;
    }

    private Statement parseTerminatedStatement() throws ParseException {
        Statement s = this.parseStatement();
        if (!Parser.isTerminal(s)) {
            this.checkSemicolon();
        }
        return s;
    }

    private void checkSemicolon() throws ParseException {
        if (this.tq.checkToken(Punctuation.SEMI)) {
            return;
        }
        if (this.tq.isEmpty()) {
            return;
        }
        if (this.semicolonInserted()) {
            FilePosition semiPoint = FilePosition.endOf(this.tq.lastPosition());
            MessageLevel lvl = this.tq.isEmpty() || this.tq.lookaheadToken(Punctuation.RCURLY) ? MessageLevel.LOG : MessageLevel.LINT;
            this.mq.addMessage((MessageTypeInt)MessageType.SEMICOLON_INSERTED, lvl, semiPoint);
        } else {
            this.tq.expectToken(Punctuation.SEMI);
        }
    }

    static boolean integerPartIsOctal(String numberLiteral) {
        int n = numberLiteral.length();
        for (int i = 0; i < n; ++i) {
            char ch = numberLiteral.charAt(i);
            if (ch == '.') {
                return false;
            }
            if (ch == '0') continue;
            return i != 0 && ch >= '1' && ch <= '9';
        }
        return false;
    }

    private AbstractStatement parseDeclarationsOrExpression(boolean insertionProtected) throws ParseException {
        boolean isDeclaration;
        TokenQueue.Mark m = this.tq.mark();
        if (this.tq.checkToken(Keyword.VAR)) {
            isDeclaration = true;
        } else if (this.tq.checkToken(Keyword.CONST)) {
            isDeclaration = true;
            this.mq.addMessage((MessageTypeInt)MessageType.NOT_IE, this.posFrom(m));
        } else {
            isDeclaration = false;
        }
        if (isDeclaration) {
            AbstractStatement s;
            Identifier idNode = this.parseIdentifierNode(false);
            Expression initializer = null;
            if (this.tq.checkToken(Punctuation.EQ)) {
                initializer = this.parseExpressionPart(insertionProtected);
            }
            Declaration d = new Declaration(this.posFrom(m), idNode, initializer);
            this.finish(d, m);
            if (this.tq.checkToken(Punctuation.COMMA)) {
                ArrayList<Declaration> decls = new ArrayList<Declaration>();
                decls.add(d);
                do {
                    TokenQueue.Mark m2 = this.tq.mark();
                    Identifier idNode2 = this.parseIdentifierNode(false);
                    Expression initializer2 = null;
                    if (this.tq.checkToken(Punctuation.EQ)) {
                        initializer2 = this.parseExpressionPart(insertionProtected);
                    }
                    Declaration d2 = new Declaration(this.posFrom(m2), idNode2, initializer2);
                    this.finish(d2, m2);
                    decls.add(d2);
                } while (this.tq.checkToken(Punctuation.COMMA));
                MultiDeclaration md = new MultiDeclaration(this.posFrom(m), decls);
                this.finish(md, m);
                s = md;
            } else {
                s = d;
            }
            return s;
        }
        return this.parseExpressionStmt(insertionProtected);
    }

    private Statement parseBody(boolean terminal) throws ParseException {
        if (terminal || this.tq.lookaheadToken(Punctuation.LCURLY)) {
            return this.parseTerminatedStatement();
        }
        Statement s = this.parseStatement();
        this.tq.checkToken(Punctuation.SEMI);
        return s;
    }

    private Block parseBodyBlock() throws ParseException {
        if (!this.tq.lookaheadToken(Punctuation.LCURLY)) {
            this.tq.expectToken(Punctuation.LCURLY);
        }
        return (Block)this.parseTerminatedStatement();
    }

    private FormalParamList parseFormalParams() throws ParseException {
        ArrayList<FormalParam> params = new ArrayList<FormalParam>();
        if (!this.tq.lookaheadToken(Punctuation.RPAREN)) {
            do {
                TokenQueue.Mark m = this.tq.mark();
                FormalParam param = new FormalParam(this.parseIdentifierNode(false));
                this.finish(param, m);
                params.add(param);
            } while (this.tq.checkToken(Punctuation.COMMA));
        }
        return new FormalParamList(params, this.mq);
    }

    private static Noop noop(FilePosition fp) {
        Noop n = new Noop(fp);
        n.setComments(Collections.emptyList());
        return n;
    }

    private FilePosition posFrom(TokenQueue.Mark startMark) throws ParseException {
        return this.posFrom(startMark.getFilePosition());
    }

    private FilePosition posFrom(ParseTreeNode childFlushWithStart) throws ParseException {
        return this.posFrom(childFlushWithStart.getFilePosition());
    }

    private FilePosition posFrom(FilePosition start) throws ParseException {
        return this.tq.isEmpty() || this.tq.currentPosition() != start ? FilePosition.span(start, this.tq.lastPosition()) : FilePosition.startOf(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(AbstractParseTreeNode n, TokenQueue.Mark startMark) throws ParseException {
        TokenQueue.Mark endMark = this.tq.mark();
        this.tq.rewind(startMark);
        try {
            n.setComments(this.tq.filteredTokens());
        }
        finally {
            this.tq.rewind(endMark);
        }
    }

    private static void issueLintWarningsForProblematicEscapes(Token<JsTokenType> t, MessageQueue mq) {
        String body = t.text.substring(1, t.text.length() - 1);
        int i = -1;
        while ((i = body.indexOf(92, i + 1)) >= 0) {
            char next = body.charAt(i + 1);
            switch (next) {
                case '\"': 
                case '\'': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case 'X': 
                case '\\': 
                case 'b': 
                case 'f': 
                case 'n': 
                case 'r': 
                case 't': 
                case 'u': 
                case 'x': {
                    break;
                }
                case 'v': {
                    mq.addMessage((MessageTypeInt)MessageType.AMBIGUOUS_ESCAPE_SEQUENCE, t.pos, MessagePart.Factory.valueOf("\\" + next));
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case 'S': 
                case 'W': 
                case '[': 
                case ']': 
                case '^': 
                case 's': 
                case 'w': 
                case '{': 
                case '|': 
                case '}': {
                    mq.addMessage((MessageTypeInt)MessageType.REDUNDANT_ESCAPE_SEQUENCE, t.pos, MessagePart.Factory.valueOf("\\" + next));
                }
            }
            ++i;
        }
    }

    private static Operation checkInExprWithLhs(Statement s) {
        if (!(s instanceof ExpressionStmt)) {
            return null;
        }
        Expression e = ((ExpressionStmt)s).getExpression();
        if (!(e instanceof Operation)) {
            return null;
        }
        Operation op = (Operation)e;
        if (Operator.IN != op.getOperator()) {
            return null;
        }
        return op.children().get(0).isLeftHandSide() ? op : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActualList
    extends AbstractExpression {
        ActualList(List<Expression> actuals) {
            super(FilePosition.UNKNOWN, Expression.class);
            this.createMutation().appendChildren(actuals).execute();
        }

        public List<? extends Expression> children() {
            return this.childrenAs(Expression.class);
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void render(RenderContext rc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeOf() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FormalParamList {
        public List<FormalParam> params;

        public FormalParamList(List<FormalParam> params, MessageQueue mq) {
            HashSet<String> paramNames = new HashSet<String>();
            paramNames.add("arguments");
            paramNames.add("this");
            for (FormalParam p : params) {
                if (paramNames.add(p.getIdentifierName())) continue;
                mq.addMessage((MessageTypeInt)MessageType.DUPLICATE_FORMAL_PARAM, p.getFilePosition(), MessagePart.Factory.valueOf(p.getIdentifierName()));
            }
            this.params = params;
        }
    }
}

