/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.reporting.RenderContext;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RealLiteral
extends NumberLiteral {
    private final double value;

    @ParseTreeNode.ReflectiveCtor
    public RealLiteral(FilePosition pos, Number value, List<? extends ParseTreeNode> children) {
        this(pos, value.doubleValue());
    }

    public RealLiteral(FilePosition pos, double value) {
        super(pos);
        this.value = value;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        if (Double.isNaN(this.value)) {
            out.consume("(");
            out.consume("0");
            out.consume("/");
            out.consume("0");
            out.consume(")");
        } else if (Double.isInfinite(this.value)) {
            out.consume("(");
            if (this.value < 0.0) {
                out.consume("-");
            }
            out.consume("1");
            out.consume("/");
            out.consume("0");
            out.consume(")");
        } else if (this.value == 0.0 && 1.0 / this.value < 0.0) {
            out.consume("(");
            out.consume("-");
            out.consume("0");
            out.consume(")");
        } else {
            super.render(rc);
        }
    }
}

