/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Directive;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.quasiliteral.QuasiNode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DirectivePrologueQuasiNode
extends QuasiNode {
    private final Set<String> directives;

    public DirectivePrologueQuasiNode(Set<String> directives) {
        super(new QuasiNode[0]);
        this.directives = new LinkedHashSet<String>(directives);
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        if (specimens.isEmpty()) {
            return false;
        }
        ParseTreeNode specimen = specimens.get(0);
        if (!(specimen instanceof DirectivePrologue)) {
            return false;
        }
        DirectivePrologue usd = (DirectivePrologue)specimen;
        if (!usd.getDirectives().containsAll(this.directives)) {
            return false;
        }
        specimens.remove(0);
        return true;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        ArrayList<Directive> subsets = new ArrayList<Directive>();
        for (String subsetName : this.directives) {
            subsets.add(new Directive(FilePosition.UNKNOWN, subsetName));
        }
        substitutes.add(new DirectivePrologue(FilePosition.UNKNOWN, subsets));
        return true;
    }
}

