/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.quasiliteral.QuasiNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectConstructorHole
extends QuasiNode {
    private final String keyIdentifier;
    private final String valueIdentifier;

    public ObjectConstructorHole(String keyIdentifier, String valueIdentifier) {
        super(new QuasiNode[0]);
        this.keyIdentifier = keyIdentifier;
        this.valueIdentifier = valueIdentifier;
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        if (specimens.isEmpty()) {
            return false;
        }
        if (!(specimens.get(0) instanceof ObjectConstructor)) {
            return false;
        }
        assert (specimens.get(0).children().size() % 2 == 0);
        ArrayList<ParseTreeNode> keyList = new ArrayList<ParseTreeNode>();
        ArrayList<ParseTreeNode> valueList = new ArrayList<ParseTreeNode>();
        int i = 0;
        while (i < specimens.get(0).children().size()) {
            keyList.add(specimens.get(0).children().get(i++));
            valueList.add(specimens.get(0).children().get(i++));
        }
        specimens.remove(0);
        return ObjectConstructorHole.putIfDeepEquals(bindings, this.keyIdentifier, new ParseTreeNodeContainer(keyList)) && ObjectConstructorHole.putIfDeepEquals(bindings, this.valueIdentifier, new ParseTreeNodeContainer(valueList));
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        if (bindings.containsKey(this.keyIdentifier) && bindings.containsKey(this.valueIdentifier)) {
            ParseTreeNode keyNode = bindings.get(this.keyIdentifier);
            ParseTreeNode valueNode = bindings.get(this.valueIdentifier);
            assert (keyNode.children().size() == valueNode.children().size());
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (int i = 0; i < keyNode.children().size(); ++i) {
                children.add((Expression)keyNode.children().get(i));
                children.add((Expression)valueNode.children().get(i));
            }
            substitutes.add(new ObjectConstructor(FilePosition.UNKNOWN, null, children));
            return true;
        }
        return false;
    }
}

